//***	FSRP.H -- File System Request Packet Structures for C FSD Implementations.
//
//1.	Functional Description.
//	This include file contains structure definitions for use by
//	file system drivers (FSDs) written in C.
//
//2.	Modification History.
//	S. E. Jones	93/02/27.	#1.101, original.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1993-1995 General Software, Inc.

#ifndef _FSRP
#define _FSRP

//
// This structure defines the layout of a File System Request Packet,
// used as the basic control block to pass to FSD drivers.
//

typedef struct _FSRP {
    UCHAR fsrp_cmd;			// IN command code.
    USHORT fsrp_status;                 // OUT FSD driver's return status code.

#define FSRPSTATUS_ERROR	0x8000	// indicates error.
#define FSRPSTATUS_RETMASK	0x00ff	// error code if FSRPSTATUS_ERROR.

    //
    // The following fields are used internally by Embedded DOS.
    //

    ULONG fsrp_linkage;                 // pointer to next FSRP in chain.

    //
    // The following are general IN/OUT parameters for the request.
    //

    PSHTE fsrp_shte;			// IN FWA, SHTE for this request.
    PVOID fsrp_buffer;			// IN OUT buffer pointer.
    UCHAR *fsrp_pathname;		// IN offset FWA, major path.
    UCHAR *fsrp_pathname2;		// IN offset FWA, second path (rename).
    USHORT fsrp_count;			// IN OUT byte count value.
    USHORT fsrp_flags;			// flags used to hold attributes, etc.
} FSRP, *PFSRP;

//
// The following flags are used by the FSD_FILEINFO & FILETIME requests.
//

#define FSRP_FLAGS_SET		0x0001	// if setting info, else getting info.

#endif // _FSRP
