	TITLE	HELLO - First Simple Test Program For Starlite.

;***	HELLO -- First Simple Test Program For Starlite.
;
;1.	Functional Description.
;	This program prints a "HELLO WORLD\n" message with the PRINTF macro
;	proving that .EXE programs can be loaded.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;
;3.	NOTICE: Copyright (C) 1990 General Software.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

	include ..\inc\usegs.inc
	include ..\inc\udefines.inc
	include ..\inc\umacros.inc
	include ..\inc\ustruc.inc

;	Define the stack.

STACK	SEGMENT
	db	512 dup ('$')
TopStack =	$
STACK	ENDS

UCODE	SEGMENT

;***	Main - Main Entrypoint.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is the entrypoint of the test program.  We print
;	a "HELLO WORLD\n" message with the PRINTF macro and then exit.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Main, PUBLIC, FAR
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP		; (DS) = DGROUP.

	PRINTF	<Main: HELLO WORLD.\n>
	PRINTF	<Main: CS=$x, DS=$x, ES=$x, SS=$x, SP=$x.\n>, \
		<cs, ds, es, ss, sp>

;	Now int 3 so we can see what happened to the stack.

;	int	3

;	Now terminate the process and return to STARLITE.

	mov	ah, DOSEXIT
	mov	al, 0			; successful status code.
	int	21h			; terminate program.
EndProc Main

UCODE	ENDS
	END	Main
