//***	HANDLE.H -- Embedded DOS Handle API Definitions for C Language Programs.
//
//1.	Functional Description.
//	This include file contains prototypes for the Embedded DOS HANDLE API.
//
//2.	Modification History.
//	S. E. Jones	93/03/16.	#1.101, original.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1993-1995 General Software, Inc.

#ifndef _HANDLE_API
#define _HANDLE_API

//
// This module depends on KTYPES.
//

#include "..\inc\ktypes.h"		// conditionally includes types.

typedef (HANDLE_REFERENCE_ROUTINE)(PVOID UserToken);
typedef (*PHANDLE_REFERENCE_ROUTINE)(PVOID UserToken);

typedef (HANDLE_DEREFERENCE_ROUTINE)(PVOID UserToken);
typedef (*PHANDLE_DEREFERENCE_ROUTINE)(PVOID UserToken);

extern STATUS ExCreateHandleTable (PVOID Table, USHORT TableLength);

extern STATUS ExCloseHandleTable (PVOID Table);

extern STATUS ExAllocateHandle (
    PVOID Table,
    PVOID Token,
    PHANDLE_REFERENCE_ROUTINE ReferenceRoutine,
    PHANDLE_DEREFERENCE_ROUTINE DereferenceRoutine,
    PHANDLE Handle);

extern STATUS ExDeallocateHandle (PVOID Table, HANDLE Handle);

extern STATUS ExAccessHandle (PVOID Table, HANDLE Handle, PVOID *Token);

extern STATUS ExDeaccessHandle (PVOID Table, HANDLE Handle);

#endif // not defined, _HANDLE_API
