/*
// PROGRAM NAME:  IOHELPC.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program is a simple example of how to call Embedded DOS I/O
//	Helper services from a C-language program.  It creates a file called
//	FOO, writes a message to the file, and uses IoFsInfo to get information
//	about the drive that FOO is on, and then closes it.  The volume
//	information is displayed to STDOUT.
//
//	This program must be linked with GENERAL\LIB\OBJ\IOHELP.OBJ in
//	order to resolve the I/O Helper function names.
//
// MODIFICATION HISTORY.
//	S. E. Jones	93/09/18.	#1.106, original.
//	S. E. Jones	95/11/13.	#6-XL v40, added call to IoFsInfo.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE ARGUMENTS.
//	none.
//
// NOTICE:  Copyright (C) 1993-1995 General Software, Inc.
*/

#define VOID void
#define UCHAR unsigned char
#define USHORT unsigned short
#define ULONG unsigned long
#define FALSE 0
#define TRUE (!FALSE)

#include <stdio.h>

#include "..\inc\system.h"	// general Embedded DOS equates.
#include "..\inc\iohelp.h"	// I/O Helper API definitions.
#include "..\inc\fsib.h"	// I/O Helper FSIB structure.

#define BUFSIZE 128
static UCHAR DataBuf [BUFSIZE]; // buffer for file I/O.

static FSIB FsInfoBuf;		// filled-in by call to IoFsInfo.

VOID main (int argc, char *argv[])
{
    STATUS retcode;
    HANDLE Handle;
    USHORT Length, BytesWritten;

    printf ("This is a simple C program that creates a file called FOO.\n");

    //
    // Open a file called FOO on the current drive.
    //

    retcode = IoCreate ("FOO", 0, 0, &Handle);
    if (retcode != DOSERR_SUCCESS) {
	printf ("IoCreate returned failing status, %u.\n", retcode);
	exit (retcode);
    }

    //
    // Prepare a buffer containing a string to write to the file.
    //

    strcpy (DataBuf, "This is the data to be written to the file.");
    Length = strlen (DataBuf);

    //
    // Write the contents of the buffer to the file.
    //

    retcode = IoWrite (Handle, DataBuf, Length, &BytesWritten);
    if (retcode != DOSERR_SUCCESS) {
	printf ("IoWrite returned failing status, %u.\n", retcode);
	IoClose (Handle);
	exit (retcode);
    }
    if (BytesWritten != Length) {
	printf ("IoWrite only wrote %u bytes; it should have been %u.\n",
		BytesWritten, Length);
	IoClose (Handle);
	exit (-1);
    }

    //
    // Conveniently, we have an open handle not only to the file, but
    // also the device.  Use IoFsInfo to return information about the
    // volume (drive) that FOO resides on, and print-out that information.
    //

    retcode = IoFsInfo (Handle, &FsInfoBuf);
    if (retcode != DOSERR_SUCCESS) {
	printf ("IoFsInfo returned failing status, %u.\n", retcode);
    } else {
	printf ("Information from IOFSINFO about the volume:\n\n");
	printf ("  Total clusters:       %lu\n", FsInfoBuf.fsib_tau);
	printf ("  Free clusters:        %lu\n", FsInfoBuf.fsib_fau);
	printf ("  Sectors per cluster:  %u\n", FsInfoBuf.fsib_bpau);
	printf ("  Sector size:          %u\n", FsInfoBuf.fsib_bs);
	printf ("\n");
    }

    //
    // Close the handle to the file.  This is when the file is actually
    // deemed "created" by the operating system.
    //

    retcode = IoClose (Handle);
    if (retcode != DOSERR_SUCCESS) {
	printf ("IoClose returned failing status, %u.\n", retcode);
	exit (retcode);
    }

    exit (0);			// successfully return to Embedded DOS.
} // iohelpc.c
