/*---------------------------------------------------------------------------
**
**	COMMDRV.C
**
**
**	(c) 2000-2001, ProSoft Technologies, Inc., All Rights Reserved
**	Ken D. Hopwood
**
**
**	MODIFIED :
**
**		12/29/2000 - 01/18/2001 -- Created example code.
**		03/16/2001 -- Changed code relating to move of variable
**						Apperr to the interface structure.
**
**	Title:	This file contains the communication driver example code
**			for the ADM module.
**
**  Abstract:
**
**
**	This program may serve as a starting point or an example
**	for custom applications.
**
**  Environment:	MVI
**                  MS-DOS
**                  Borland C/C++ Compiler (16-bit)
**
**
** ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
** and re-distribute this program provided that this copyright notice and
** license appear on all copies of the software.
**
** Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
** IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
** HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
** BY THE LICENSEE.
**
** PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
** DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
** DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
** ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
**
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**	COMPILER SWITCHES TO BUILD DIFFERENT VERSIONS OF THE SOFTWARE
**---------------------------------------------------------------------------
*/

#define REV_1_3

/*---------------------------------------------------------------------------
**	Include files
**---------------------------------------------------------------------------
*/

#include "..\..\ADM-SAMPLE\inc\main_app.h"

#include <string.h>
#include <stdio.h>

/*---------------------------------------------------------------------------
**	CONSTANT DEFINITIONS
**---------------------------------------------------------------------------
*/

#if defined(REV_1_3)
#define MAX_TIMER  65535000L
#endif

/*---------------------------------------------------------------------------
**	Function prototypes
**---------------------------------------------------------------------------
*/

void CommRun(int app_port);
int DataReady(int ComPort);


/*---------------------------------------------------------------------------
**	Variable definitions
**---------------------------------------------------------------------------
*/

extern ADM_PORT ports[];
extern ADM_PORT_ERRORS port_err[];
extern short debug_mode;
extern ADMHANDLE adm_handle;				/* handle to ADM API */
extern ADM_INTERFACE * interface_ptr;


/*---------------------------------------------------------------------------
**	Functions
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**
**
**	Description:
**
**	Arguments:
**		int app_port: Application port number (1 / 2)
**
**	External effects:
**
**
**	Return value:
**		none
**
**---------------------------------------------------------------------------
**	Notes:
**
**
**---------------------------------------------------------------------------
*/

void CommRun(int app_port)
{

	static int len;
	int i, state, saveDB, rc;
	long dummy = 0L;
//printf("state = %d\n", ports[app_port].state);
	switch(ports[app_port].state)
	{
		case -1:	/* setup for listen -- wait for master poll */
			if(DataReady(COM2+app_port) > 0)
			{
				ports[app_port].state    = 1;    	/* check for response */
				ports[app_port].ComState = 0;
				ports[app_port].buff_ptr = 0;
				MVIsp_SetRTS(COM2+app_port, OFF);
				if(ports[app_port].CurErr)
					ports[app_port].LastErr = ports[app_port].CurErr;
				ports[app_port].CurErr  = 0;
			}
			return;

		case 1:		/* receiving data */
			ports[app_port].expLen   = 1000;   	/* initialize expected len */
			rc = MVIsp_Gets(COM2+app_port, &(unsigned char)ports[app_port].buff[ports[app_port].buff_ptr], _LF, &ports[app_port].expLen,
				TIMEOUT_ASAP);
//printf("rc = %d\n", rc);
			if(rc == MVI_SUCCESS)
			{
				len = ports[app_port].buff_ptr + ports[app_port].expLen;
				ports[app_port].state = 2;
				port_err[app_port].Requests++;
			}
			if(ports[app_port].expLen > 0)
			{
				ADM_DAWriteRecvData(adm_handle, interface_ptr, app_port,
                                 ports[app_port].expLen, &ports[app_port].buff[ports[app_port].buff_ptr]);
				ports[app_port].buff_ptr = ports[app_port].buff_ptr + ports[app_port].expLen;		/* bump string pointer */
				ports[app_port].buff[ports[app_port].buff_ptr] = (char)NULL;
			}
			return;

		case 2:		/* save to database at offset where the write data area is */
         saveDB = 1000;
//         saveDB = interface_ptr->adm_bt_data_ptr->wr_start;
			/* The offset of the valiable saveDB is just an example, the offset can be anywhere in the DB  */
         /* In this case the offset is where the write data is. */
			ADM_DBSetRegs(adm_handle, saveDB, (const unsigned short)(len/2), (unsigned short *) ports[app_port].buff);
#if defined(MVI46)
			/* save to M1 file */
			MVIbp_WriteModuleFile(interface_ptr->handle, FILTYP_M1, (WORD *)ports[app_port].buff, saveDB, len/2);
#endif
			for(i=0;i<len/2;i++)
			{
				ADM_DBSwapWord(adm_handle, saveDB + i);
			}
			ports[app_port].len = len;
			ports[app_port].state = 2000;
			ports[app_port].ComState = 2;
			return;

		case 2000:		/* send response to master */
			switch(ports[app_port].ComState)
			{
				case 2:		/* Turn RTS On & start timer */
					ADM_DAWriteSendCtl(adm_handle, interface_ptr,app_port, RTSON);
					MVIsp_SetRTS(COM2+app_port, ON);
					ports[app_port].tmout = ports[app_port].RTS_On * 1000L;
					ADM_CheckTimer(adm_handle, &ports[app_port].tmlast, &dummy);
					ports[app_port].ComState = 3;

				case 3:		/* wait for RTS on timeout */
					ADM_CheckTimer(adm_handle, &ports[app_port].tm, &dummy);
					if(ports[app_port].tm > ports[app_port].tmlast)
						ports[app_port].tmdiff = (long)(ports[app_port].tm-ports[app_port].tmlast);
					else
						ports[app_port].tmdiff = (long)(ROLLOVER - ports[app_port].tmlast) + ports[app_port].tm;
#if defined(REV_1_3)
					ports[app_port].tmdiff &= 0x0000ffffL;
					ports[app_port].tmlast = ports[app_port].tm;
					if(ports[app_port].tmdiff < ports[app_port].tmout && ports[app_port].tmout < MAX_TIMER)
						ports[app_port].tmout -= ((long) ports[app_port].tmdiff & 0xffff);
					else
						ports[app_port].tmout = 0L;
#else
					ports[app_port].tmlast = ports[app_port].tm;
					ports[app_port].tmout -= ((long) ports[app_port].tmdiff & 0xffff);
#endif
					if(ports[app_port].tmout > 0L)
						return;

					if(ports[app_port].CTS == 'Y')	/* check for CTS */
					{
						if(MVIsp_GetCTS(COM2+app_port, &state) != MVI_SUCCESS)
						{
							MVIsp_SetRTS(COM2+app_port,OFF);
							ports[app_port].ComState = 0;
							ports[app_port].state = -1;		/* set to read data */
							interface_ptr->Apperr = 1;
							if(ports[app_port].CurErr)
								ports[app_port].LastErr = ports[app_port].CurErr;
							ports[app_port].CurErr  = -1;
							return;
						}
						if(state != ON)
						{
							MVIsp_SetRTS(COM2+app_port,OFF);
							ports[app_port].ComState = 0;
							ports[app_port].state = -1;		/* set to read data */
							interface_ptr->Apperr = 1;
							if(ports[app_port].CurErr)
								ports[app_port].LastErr = ports[app_port].CurErr;
							ports[app_port].CurErr  = -1;
							return;
						}
						ADM_DAWriteRecvCtl(adm_handle, interface_ptr, app_port, CTSRCV);
					}
					ports[app_port].tmout = 5000000L;	/* five seconds to transmit message */
					ADM_CheckTimer(adm_handle, &ports[app_port].tmlast, &dummy);
					ports[app_port].ComState = 4;

				case 4:  	/* send data */
					state = 0;
					MVIsp_GetCountUnsent(COM2+app_port, &state);
					if(state)
						return;
					state = ports[app_port].len;
					MVIsp_PutData(COM2+app_port, (unsigned char *)ports[app_port].buff, &state, TIMEOUT_ASAP);
					ports[app_port].ComState = 5;

					ADM_DAWriteSendData(adm_handle, interface_ptr, app_port, ports[app_port].len, ports[app_port].buff);

				case 5:		/* start RTS off timer after all bytes sent */
					state = 0;
					MVIsp_GetCountUnsent(COM2+app_port, &state);
					if(state)
					{
						ADM_CheckTimer(adm_handle, &ports[app_port].tm, &dummy);
						if(ports[app_port].tm > ports[app_port].tmlast)
							ports[app_port].tmdiff = (long)(ports[app_port].tm-ports[app_port].tmlast);
						else
							ports[app_port].tmdiff = (long)(ROLLOVER - ports[app_port].tmlast) + ports[app_port].tm;
#if defined(REV_1_3)
					ports[app_port].tmdiff &= 0x0000ffffL;
					ports[app_port].tmlast = ports[app_port].tm;
					if(ports[app_port].tmdiff < ports[app_port].tmout && ports[app_port].tmout < MAX_TIMER)
						ports[app_port].tmout -= ((long) ports[app_port].tmdiff & 0xffff);
					else
						ports[app_port].tmout = 0L;
#else
					ports[app_port].tmlast = ports[app_port].tm;
					ports[app_port].tmout -= ((long) ports[app_port].tmdiff & 0xffff);
#endif
						if(ports[app_port].tmout > 0L)
							return;
						else	/* timeout waiting to send data */
						{
							MVIsp_SetRTS(COM2+app_port, OFF);
							ports[app_port].state = -1;
							ports[app_port].ComState = 0;
							interface_ptr->Apperr = 1;
							if(ports[app_port].CurErr)
								ports[app_port].LastErr = ports[app_port].CurErr;
							ports[app_port].CurErr  = -2;
							return;
						}
					}
					ports[app_port].tmout = ports[app_port].RTS_Off * 1000L;
					ADM_CheckTimer(adm_handle, &ports[app_port].tmlast, &dummy);
					ports[app_port].ComState = 6;

				case 6:		/* Turn RTS off */
					ADM_CheckTimer(adm_handle, &ports[app_port].tm, &dummy);
					if(ports[app_port].tm > ports[app_port].tmlast)
						ports[app_port].tmdiff = (long)(ports[app_port].tm-ports[app_port].tmlast);
					else
						ports[app_port].tmdiff = (long)(ROLLOVER - ports[app_port].tmlast) + ports[app_port].tm;
#if defined(REV_1_3)
					ports[app_port].tmdiff &= 0x0000ffffL;
					ports[app_port].tmlast = ports[app_port].tm;
					if(ports[app_port].tmdiff < ports[app_port].tmout && ports[app_port].tmout < MAX_TIMER)
						ports[app_port].tmout -= ((long) ports[app_port].tmdiff & 0xffff);
					else
						ports[app_port].tmout = 0L;
#else
					ports[app_port].tmlast = ports[app_port].tm;
					ports[app_port].tmout -= ((long) ports[app_port].tmdiff & 0xffff);
#endif
					if(ports[app_port].tmout > 0L)
						return;
					MVIsp_SetRTS(COM2+app_port, OFF);
					ports[app_port].ComState = 0;
					ports[app_port].state = -1;    //set to read data
					port_err[app_port].Responses++;

					ADM_DAWriteSendCtl(adm_handle, interface_ptr, app_port, RTSOFF);
			}
			return;

		default:
			ports[app_port].state = -1;
			ports[app_port].ComState = 0;
	}
}


/*---------------------------------------------------------------------------
**
**
**	Description:
**		This functions checks to see if there is any data available for the
**		selected port.
**
**	Arguments:
**		int ComPort -- port number to consider.
**
**	External effects:
**
**
**	Return value:
**		The function returns the number of bytes available in the receive
**      buffer for the port.
**
**---------------------------------------------------------------------------
**	Notes:
**
**
**---------------------------------------------------------------------------
*/

int DataReady(int ComPort)
{
	int cnt;

	if(MVIsp_GetCountUnread(ComPort, &cnt) != MVI_SUCCESS)
		return 0;
	return cnt;
}

