/*---------------------------------------------------------------------------
**
**	ADMNETAPI.H
**
**	Title:			MVI-ADMNET Communications Module API Definitions
**
**	Abstract:		This file contains definitions and declarations
**					needed in order to use the ADMAPI.LIB library
**					functions.  Include this file in all modules
**					that call the ADMAPI functions.
**
**	Environment:	MVI Communications Module
**					Borland C/C++ Compiler
**                 	General Software Embedded DOS 6-XL
**
**	Author:
**
**	Richard A. Reynolds
**	(c) 1999, Vital Computer Solutions, All Rights Reserved
**
**	Ken D. Hopwood
**  Sukhum Amorntrakul (Joe)
**	Copyright (c) 2000-2006, ProSoft Technology, All Rights Reserved
**
**	Incorporates code from 05/20/1999
**
**	MODIFIED :
**
**		11/15/2003 - Created SOCKET API code from existing works.
**      11/08/2006 - added support for Digital Mars compiler
**
**
** ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
** and re-distribute this program provided that this copyright notice and
** license appear on all copies of the software.
**
** Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
** IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
** HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
** BY THE LICENSEE.
**
** PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
** DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
** DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
** ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
**
**
**---------------------------------------------------------------------------
*/


#ifndef _ADMSK_H
#define _ADMSK_H


/*---------------------------------------------------------------------------
** Runtime Function Conversion Macros
**---------------------------------------------------------------------------
*/
#ifdef __BORLANDC__
#define INPORTB									inportb
#define INPORTW									inport
#define OUTPORTB								outportb
#define OUTPORTW								outport
#define DELAY									delay
#define OPEN									_rtl_open
#define CLOSE									_rtl_close
#define READ	  								_rtl_read
#else
#define INPORTB(__portid)						_inp(__portid)
#define INPORTW(__portid)						_inpw(__portid)
#define OUTPORTB(__portid, __value)				_outp(__portid, __value)
#define OUTPORTW(__portid, __value)				_outpw(__portid, __value)
#define DELAY(__milliseconds)					delay_ms(__milliseconds)
#define OPEN(__name, __flags)		  			_open(__name, __flags)
#define READ(__fd, __buffer, __len)				_read(__fd, __buffer, __len)
#endif

// ADM SOCKET
#define SK_SUCCESS 0
#define SK_PORT_NOT_ALLOW 1
#define SK_CANNOT_ALLOCATE_MEMORY 2
#define SK_NOT_FOUND 3
#define SK_PROCESS_SOCKET 4
#define SK_SOCKET_CLOSE 5
#define SK_TIMEOUT 6
#define SK_OPENED 7

typedef unsigned long longword;     // 32 bits
typedef unsigned short word;        // 16 bits
typedef unsigned char byte;         //  8 bits


#define USE_TCP 1
#define USE_UDP 2

typedef struct
{
	char			APISeries[4];
	short			APIRevisionMajor;
	short			APIRevisionMinor;
	long			APIRun;
}ADMNETVERSIONINFO;

int ADM_init_socket(int numSK, int portNum, int buffSize, char *name);
int ADM_release_sockets(void);
void ADM_NET_GetVersionInfo(ADMNETVERSIONINFO* admnet_verinfo);
int ADM_receive_socket(char *skName, char *holdRecPtr, int *readLen, int protocol);
int ADM_send_socket(char *skName, char *holdRecPtr, int *sendLen, char *ServerIPAddress, int protocol);

int ADM_is_sk_open(char *skName);
int ADM_open_sk(char *skName, char *ServerIPAddress, int protocol);
int ADM_close_sk(char *skName);
int ADM_receive_sk(char *skName, char *holdRecPtr, int *readLen, char *fromIP);
int ADM_send_sk(char *skName, char *holdSendPtr, int *sendLen);


#endif
