	TITLE	MT1 - Multitasking Sample Test Program #1.

;***	MT1 -- Multitasking Sample Test Program #1.
;
;1.	Functional Description.
;	This program shows how to write applications in assembly language
;	that allocate threads to perform work in parallel.  This example
;	shows how to:
;
;	1.  Allocate and deallocate threads to perform parallel work, and
;	2.  Use event objects for synchronization of work, and
;	3.  Clean-up allocated objects using a special INVALID value.
;
;2.	Modification History.
;	S. E. Jones	93/09/18.	#1.106, original.
;
;3.	NOTICE: Copyright (C) 1993 General Software.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

	include ..\inc\usegs.inc
	include ..\inc\udefines.inc
	include ..\inc\umacros.inc
	include ..\inc\ustruc.inc

;	Kernel definitions.

	include ..\inc\kernel.inc

;	DOS call definitions.

	include ..\inc\dosapi.inc
	include ..\inc\doserr.inc

;	Define the main thread's stack.

_STACK	SEGMENT
	db	512 dup ('$')
TopStack =	$
_STACK	ENDS

UDATA	SEGMENT

MAXCHARS =	500

INVALID =	0ffffh

Trigger dw	INVALID         ; trigger event to get threads going.

Thread1 dw	INVALID         ; thread handle #1.
Thread2 dw	INVALID         ; thread handle #2.

Done1	dw	INVALID         ; event set by thread #1.
Done2	dw	INVALID         ; event set by thread #2.

UDATA	ENDS

UCODE	SEGMENT

;***	Thread1Func - Thread Function #1.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is executed in the context of a separate thread,
;	on a separate stack allocated from system pool.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/09/18.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	Does not return.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Thread1Func
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP

;	Wait for the main thread to trigger us to start going.

	mov	ax, Trigger		; (AX) = trigger event handle.
	mov	dl, SYS_WAIT_EVENT	; (DL) = function code.
	int	SYSINT			; wait before starting I/O.

;	Now write '1's to the screen, which will be interspersed with '2's.

	mov	cx, MAXCHARS		; (CX) = # characters to write.
Thread1Func_Loop:
	mov	ah, 02h                 ; (AH) = output char to console.
	mov	dl, '1'                 ; (DL) = character to write.
	int	21h
	loop	Thread1Func_Loop	; write the rest of the characters.

;	Now set our handle to INVALID, so the main thread will not
;	destroy this thread (we will destroy ourselves).

	mov	Thread1, INVALID

;	Set our Done event so the main thread knows we're done.

	mov	ax, Done1		; (AX) = our done event handle.
	mov	dl, SYS_SET_EVENT	; (DL) = function code.
	int	SYSINT			; set the event.

;	Destroy this thread.

	sub	ax, ax			; (AX) = 0 (handle meaning self).
	mov	dl, SYS_DEALLOCATE_THREAD ; (DL) = function code.
	int	SYSINT			; destroy this thread.
EndProc Thread1Func

;***	Thread2Func - Thread Function #2.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is executed in the context of a separate thread,
;	on a separate stack allocated from system pool.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/09/18.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	Does not return.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Thread2Func
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP

;	Wait for the main thread to trigger us to start going.

	mov	ax, Trigger		; (AX) = trigger event handle.
	mov	dl, SYS_WAIT_EVENT	; (DL) = function code.
	int	SYSINT			; wait before starting I/O.

;	Now write '2's to the screen, which will be interspersed with '1's.

	mov	cx, MAXCHARS		; (CX) = # characters to write.
Thread2Func_Loop:
	mov	ah, 02h                 ; (AH) = output char to console.
	mov	dl, '2'                 ; (DL) = character to write.
	int	21h
	loop	Thread2Func_Loop	; write the rest of the characters.

;	Now set our handle to INVALID, so the main thread will not
;	destroy this thread (we will destroy ourselves).

	mov	Thread2, INVALID

;	Set our Done event so the main thread knows we're done.

	mov	ax, Done2		; (AX) = our done event handle.
	mov	dl, SYS_SET_EVENT	; (DL) = function code.
	int	SYSINT			; set the event.

;	Destroy this thread.

	sub	ax, ax			; (AX) = 0 (handle meaning self).
	mov	dl, SYS_DEALLOCATE_THREAD ; (DL) = function code.
	int	SYSINT			; destroy this thread.
EndProc Thread2Func

;***	Main - Main Entrypoint.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is the entrypoint of the test program.  We call
;	the kernel function, AllocateThread, to create two threads that
;	run in parallel with the parent thread (us).  The threads make
;	50 DOS calls to output characters to the screen, and then set
;	their event objects so that we know when they have finished.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/09/18.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Main, PUBLIC, FAR
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP		; (DS) = DGROUP.

	mov	ax, MAXCHARS
	PRINTF	<This sample program has a main thread that allocates two\n>
	PRINTF	<worker threads.  Each thread prints its thread number in\n>
	PRINTF	<a loop $u times to show how preemption works in a simple\n>, <ax>
	PRINTF	<multithreaded system without prioritization.\n\n>

;	Allocate an event to trigger the worker threads to start running.

	mov	dl, SYS_ALLOCATE_EVENT	; (DL) = function code.
	int	SYSINT			; (AX) = event handle.
	LJC	Main_Cleanup		; if we couldn't allocate an event.
	PRINTF	<Trigger event has handle $u.\n>, <ax>
	mov	Trigger, ax		; save trigger event handle.

;	Allocate an event for thread #1.

	mov	dl, SYS_ALLOCATE_EVENT	; (DL) = function code.
	int	SYSINT			; (AX) = event handle.
	LJC	Main_Cleanup		; if we couldn't allocate an event.
	PRINTF	<Event #1 has handle $u.\n>, <ax>
	mov	Done1, ax		; save thread 1 "done" event handle.

;	Allocate an event for thread #2.

	mov	dl, SYS_ALLOCATE_EVENT	; (DL) = function code.
	int	SYSINT			; (AX) = event handle.
	jc	Main_Cleanup		; if we couldn't allocate an event.
	PRINTF	<Event #2 has handle $u.\n>, <ax>
	mov	Done2, ax		; save thread 2 "done" event handle.

;	Call the AllocateThread kernel function for each thread we want
;	to create in the system (remember, we are running as a thread here
;	as well, so we will have two worker threads, plus this one makes
;	three threads in the system.  The function code is passed through
;	the DL register.  Other operands are passed in other registers
;	according to the specifications in the Technical Reference Manual.

	mov	ax, OFFSET CGROUP:Thread1Func
	mov	cx, CGROUP		; (CX:AX) = FWA, thread function.
	mov	dl, SYS_ALLOCATE_THREAD ; (DL) = function code.
	int	SYSINT			; (AX) = new thread handle.
	jc	Main_Cleanup		; if we couldn't allocate thread #1.
	PRINTF	<Thread #1 has handle $u.\n>, <ax>

	mov	ax, OFFSET CGROUP:Thread2Func
	mov	cx, CGROUP		; (CX:AX) = FWA, thread function.
	mov	dl, SYS_ALLOCATE_THREAD ; (DL) = function code.
	int	SYSINT			; (AX) = new thread handle.
	jc	Main_Cleanup		; if we couldn't allocate thread #2.
	PRINTF	<Thread #2 has handle $u.\n>, <ax>

;	Now set the trigger event to start the threads going; they are
;	currently waiting on our Trigger event.

	mov	ax, Trigger		; (AX) = trigger event handle.
	mov	dl, SYS_SET_EVENT	; (DL) = function code.
	int	SYSINT			; set the event.
	jc	Main_Cleanup		; if we couldn't trigger the threads.

;	Now wait for both threads to complete their work.

	mov	ax, Done1		; (AX) = event handle to wait on.
	mov	dl, SYS_WAIT_EVENT	; (DL) = function code.
	int	SYSINT			; wait on the event.

	mov	ax, Done2		; (AX) = event handle to wait on.
	mov	dl, SYS_WAIT_EVENT	; (DL) = function code.
	int	SYSINT			; wait on the event.

;	Clean-up our objects here.  Both worker threads have deallocated
;	themselves because it was easiest to have them do it since they
;	have nothing better to do instead except spin and wait for us
;	to deallocate them with the provided handles.  Here we just return
;	the trigger and done events to the system.

Main_Cleanup:
	mov	ax, Trigger		; (AX) = handle to deallocate.
	cmp	ax, INVALID		; is the handle invalid?
	je	@f			; if so, skip this deallocate.
	mov	dl, SYS_DEALLOCATE_EVENT; (DL) = function code.
	int	SYSINT			; deallocate the event.

@@:	mov	ax, Done1		; (AX) = handle to deallocate.
	cmp	ax, INVALID		; is the handle invalid?
	je	@f			; if so, skip this deallocate.
	mov	dl, SYS_DEALLOCATE_EVENT; (DL) = function code.
	int	SYSINT			; deallocate the event.

@@:	mov	ax, Done2		; (AX) = handle to deallocate.
	cmp	ax, INVALID		; is the handle invalid?
	je	@f			; if so, skip this deallocate.
	mov	dl, SYS_DEALLOCATE_EVENT; (DL) = function code.
	int	SYSINT			; deallocate the event.

;	In all but error cases, our threads will have automatically
;	deallocated themselves, setting their handles to INVALID so
;	this code won't exit.  This is a nice error cleanup, though.

@@:	mov	ax, Thread1		; (AX) = handle to deallocate.
	cmp	ax, INVALID		; is the handle invalid?
	je	@f			; if so, skip this deallocate.
	mov	dl, SYS_DEALLOCATE_THREAD ; (DL) = function code.
	int	SYSINT			; deallocate the thread.

@@:	mov	ax, Thread2		; (AX) = handle to deallocate.
	cmp	ax, INVALID		; is the handle invalid?
	je	@f			; if so, skip this deallocate.
	mov	dl, SYS_DEALLOCATE_THREAD ; (DL) = function code.
	int	SYSINT			; deallocate the thread.
@@:

;	When we get here, both threads have completed their work.
;	Exit back to the DOS prompt with a DOSEXIT INT 21h call.

	PRINTF	<\nExample is finished.\n>

	mov	ah, DOSEXIT
	mov	al, 0			; successful status code.
	int	21h			; terminate program.
EndProc Main

UCODE	ENDS
	END	Main
