////////////////////////////////////////////////////////////////////////////
//
//  MVI69ADMNET-Server.c
//  This program has been modified from the previous work of others to serve
//  as a starting point for the fast implementation of custom protocols for
//  MVI customers
//
//  Original work:
//  Rich Reynolds, Vital Computer Solutions
//  (c) 1999, Vital Computer Solutions
//  All Rights Reserved
//
//  Modified by:
//  Ken Hopwood, ProSoft Technology
//  Copyright (c) 2000-2006, ProSoft Technology
//  Date    : 05/09/00  Develop LAS module for UK customer
//  Date    : 06/20/00  Develop GEN module
//  10/03/2006  Port to Digital Mars compiler
//
//  Joe Amorntrakul, ProSoft Technology
//  (c) 2005, ProSoft Technology
//  Date    : 04/08/05  Develop Sample module
//
//
//  Environment:	MVI
//						GS-DOS
//						Borland C/C++ Compiler v5.02 (16-bit DOS)
//						Digital Mars C/C++ Compiler v8.49 (16-bit DOS)
//
// ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
// and re-distribute this program provided that this copyright notice and
// license appear on all copies of the software.
//
// Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
// IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
// HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
// BY THE LICENSEE.
//
// PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
// DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
// DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
// LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
// INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
// CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
// OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//
////////////////////////////////////////////////////////////////////////////


#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>

#include "MVI69ADMNET-Server.H"

int setup_module(void);
int shutdown_module(void);
int startup(void);

//---------------------- do not edit following code -----------------------
static void interrupt intctl_c(void);
static void interrupt intcrit(void);

// Ctrl-C signal handling function.  When a Ctrl-C is recognized, this function
// is called.  The function ignores the request and must reinstall the signal
// handler for future calls.
static void interrupt intctl_c(void)
{
	return;
}

static void interrupt intcrit(void)
{
	_AX = 0;   // ignore critical error
}
//--------------------- ok to edit following code ---------------------------

#ifdef SOCKET_ENABLE
   char sockName1[] = "ReceiveSocket";
   int buffSize1 = 4096;
   int port_1 = 6565;
   int numSocket1 = 1;
	char fromIP[64];
#endif

void main(void)
{
	char str1[20];              // buffer used for port 1
	int sptr1;
   int returnCode, i, result;

#ifdef __DMC__
	extern int _8087;

	_8087 = 0; /* never use 80x87 Math Coprocessor */
#endif

	/* enable console on COM1 */
	ADM_SetConsolePort(COM1);
	/* set console to 57600 baud */
	ADM_SetConsoleSpeed(COM1, 57600L);

	/* open ADM API and get handle */
	if(ADM_Open(&adm_handle) != ADM_SUCCESS)
	{
		printf("\nFailed to open ADM API... exiting program\n");
		exit(1);
	}

	/* send status message to the status/debug port */
	printf("\nProgram Initialization....\n");
	if(!setup_module())         // Initialize hardware and load drivers
	{
		shutdown_module();      // if fail on init then shutdown
		return;
	}

	sptr1 = 0;

   // Main loop for program ---------------------------------------------------
	for(;;)
	{
		// Set APP LED on
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_ON);

#ifdef SOCKET_ENABLE
      // Check connection
      if((result=ADM_is_sk_open(sockName1)) != SK_SUCCESS) {
         while ((result = ADM_open_sk(sockName1, "0.0.0.0", USE_TCP))==SK_PROCESS_SOCKET){}
         if (result==SK_SUCCESS)
         {
            printf("Succesfuly Opened a connection!\n");
         } else {
            printf("Waiting for connection or Error Opening a connection! %d\n", result);
         }
      } else { // else receive data
         result = ADM_receive_sk(sockName1, str1, &sptr1, fromIP);
         if(result == SK_SUCCESS)
         {
            printf("Received data!\n");
         	printf("Length == %d\n", sptr1);
   			*(wrbuff+1) = *(wrbuff+1) + 1;              // receive counter for COM 1
            for (i=0; i<sptr1; i++)
         	{
         		printf("%c", *(str1+i));
         		wrbuff[i+2] = str1[i];
         	}
            printf("\n");
         }
      }
#endif

		// Set APP LED off
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);

      // increment loop counter for external health indication ----------------
		*(wrbuff) = *(wrbuff) + 1;

		// Set BP LED on
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_ON);
		// write image to backplane ---------------------------------------------
	   if((returnCode=MVIbp_WriteInputImage(interface_ptr->handle, wrbuff, 0, 30)) != MVI_SUCCESS)
		   printf("Error write to BP: %d\n", returnCode);
		// Set BP LED off
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_OFF);

      // Key Board Input ------------------------------------------------------
   	if(kbhit())
   	{
   		if(getch() == 27)
   		{
		      shutdown_module();      // if fail on init then shutdown
		      exit(1);
   		}
   		else
	         printf("Press Esc to Exit.\n\n");
   	}
	}  // End Main loop
}


///////////////////////////////////////////////////////////////////////////////
//
// This function is used to setup the module's hardware and load device
// drivers required by the application.  Most of the items to look at closely
// are going to be related to the serial port configuration value at the top of
// of the function.
//
// Input : None.
// Output: The function returns a value of 1 if successful and 0 if not.
//
///////////////////////////////////////////////////////////////////////////////

int setup_module(void)
{
	int se;

	/******************************************************************
		This section is required for the ADM API to function.
		The names of the structures may be changed to suit the
		developer's needs.  The interface structure must be initialized
		before it can be used.
	*******************************************************************
	*/

	/* initialize structure pointers */
	interface_ptr = &interface;
	interface.adm_bt_data_ptr = &bt_data;
	interface.adm_bt_err_ptr = &bt_err;

	memset(interface.adm_bt_data_ptr, 0, sizeof(ADM_BT_DATA));
	memset(interface.adm_bt_err_ptr, 0, sizeof(ADM_BLK_ERRORS));

	while(ADM_BtOpen(adm_handle, interface_ptr, 0) != MVI_SUCCESS){
   	ADM_BtClose(adm_handle, interface_ptr);	   
	}
   printf("Successfully open Backplane\n");

	MVIbp_GetVersionInfo(interface_ptr->handle, &verinfo);
	MVIsp_GetVersionInfo(&spverinfo);
	ADM_GetVersionInfo(adm_handle, &adm_version);

	//----------- do not edit next 6 lines of code---------------------------
	disable();
	setvect(0x24, intcrit);     // install in ISR handler for CTRL-C
	setvect(0x23, intctl_c);    // install in ISR handler for CTRL-C
	setvect(0x1B, intctl_c);    // install in ISR handler for CTRL-Break
	setcbrk(0);                 // force DOS to ignore Ctrl-C
	enable();

	// Open serial interface API
	// Set comm parameters
	printf("Open Communication Port 1 9600 8 1 None....");
	se = MVIsp_Open(COM2, BAUD_9600, PARITY_NONE, WORDLEN8, STOPBITS1);
	if(se != MVI_SUCCESS){
	   printf("Unsuccessfully!\n");
		return 0;
	}
	else
	   printf("Successfully!\n");

	printf("Open Communication Port 2 9600 8 1 None....");
	se = MVIsp_Open(COM3, BAUD_9600, PARITY_NONE, WORDLEN8, STOPBITS1);
	if(se != MVI_SUCCESS){
	   printf("Unsuccessfully!\n");
		return 0;
	}
	else
	   printf("Successfully!\n");

	// Set comm handshaking
	MVIsp_SetHandshaking(COM2, HSHAKE_NONE);
	MVIsp_SetHandshaking(COM3, HSHAKE_NONE);

	// Set module status LED
	MVIbp_SetModuleStatus(adm_handle, MVI_MODULE_STATUS_OK);

	// Set user LED1 on to indicate program running
	MVIbp_SetUserLED(adm_handle, MVI_LED_USER1, MVI_LED_STATE_ON);

#ifdef SOCKET_ENABLE
	/* initialize TCP/IP socket */
	sock_init();    //initialize the socket interface
	/* initialize each socket */
	if(ADM_init_socket(numSocket1, port_1, buffSize1, sockName1) != SK_SUCCESS)
	{
		printf("Error: Initialize Socket %s\n", sockName1);
		ADM_release_sockets();
	}
	ADM_NET_GetVersionInfo(&admnet_version);
#endif

	printf("\nVERSION INFORMATION:\n\n\
  %s\n\
  (c) 1999-2018, ProSoft Technology, Inc.\n\n\
  PRODUCT NAME CODE         : %s\n\
  SOFTWARE REVISION LEVEL   : %s\n\
  RUN NUMBER                : %s\n\n\
  BACKPLANE DRIVER VERSION  : %d.%d\n\
  BACKPLANE API VERSION     : %d.%d\n\
  SERIAL API VERSION        : %d.%d\n\
  ADM API VERSION           : %d.%d\n\
  ADMNET API VERSION        : %d.%d\n\n",
	"MVI69ADMNET",
	"ADMNET Server",
	"2.40",
	"12/06/2018",
	verinfo.BPDDSeries, verinfo.BPDDRevision,
	verinfo.APISeries, verinfo.APIRevision,
	spverinfo.APISeries, spverinfo.APIRevision,
	adm_version.APIRevisionMajor, adm_version.APIRevisionMinor,
	admnet_version.APIRevisionMajor, admnet_version.APIRevisionMinor);

	printf("Press Esc to Exit.\n\n");

	return 1;
}

///////////////////////////////////////////////////////////////////////////////
//
// This function is used to shutdown the module's hardware and device drivers.
//
// Input : None.
// Output: The function will always return a value of 1.
//
///////////////////////////////////////////////////////////////////////////////

int shutdown_module(void)
{
	MVIbp_SetUserLED(adm_handle, MVI_LED_USER1, MVI_LED_STATE_OFF);
	MVIbp_SetUserLED(adm_handle, MVI_LED_USER2, MVI_LED_STATE_OFF);
	MVIbp_SetModuleStatus(adm_handle, MVI_MODULE_STATUS_FAULTED);

	/* close the backplane driver */
	printf("Closing Backplane Driver....\n");
	ADM_BtClose(adm_handle, interface_ptr);
	/* close the com driver */
	printf("Closing Serial Port Driver....\n");
	MVIsp_Close(COM2);
	MVIsp_Close(COM3);

#ifdef SOCKET_ENABLE
	printf("Releasing Sockets....");
	ADM_release_sockets();
#endif

	return 1;
}

