;***	SPE.INC -- Embedded DOS System Pool Entry/Element.
;
;1.	Functional Description.
;	This structure defines the layout of an entry in the system memory
;	pool when it is on the free list.  Entries cannot be extended or
;	shrunk; they are simply allocated and freed.  The fwdlink field
;	points to the next block in the list.  The usecnt field contains
;	the number of reasons why the block cannot be freed into the pool
;	again.	This allows multiple threads of execution to share the
;	same pool blocks and dynamically free them-- even at interrupt
;	time.  Of course, if spe_usecnt is equal to zero (0), then the
;	block is not in use.  Allocating a block intrinsically sets this
;	value to 1 so that other threads of execution cannot get at it.
;	The spe_length field contains the number of bytes in this block,
;	excluding the header (SIZE SPE-1).  The user of this block may
;	store its data following this header.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	90/11/24.	Added record locking.
;	S. E. Jones	91/01/12.	Removed DCE's.
;	S. E. Jones	91/01/13.	Added FMT's and FCE's.
;	S. E. Jones	91/11/19.	#1.094, added thread object.
;	S. E. Jones	92/07/26.	#1.099, added named objects.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	94/04/28.	#2.1, removed DFS.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

SPE		struc
spe_fwdlink	dw	?		; offset FWA, next free entry in pool.
spe_usecnt	dw	?		; reasons why we can't free this block.
spe_length	dw	?		; size of block in bytes.
spe_type	dw	?		; object type.
SPE		ends

SPE_TYPE_DATA		=	0	; default: just untyped data.
SPE_TYPE_EVENT		=	1	; event object.
SPE_TYPE_MUTEX		=	2	; mutex object.
SPE_TYPE_FFO		=	3	; FAT File object.
SPE_TYPE_TIMER		=	4	; timer object.
SPE_TYPE_IOBUF		=	5	; I/O system cooked buffer.
SPE_TYPE_USER_HANDLE_TABLE =	6	; PSP's extended handle table.
SPE_TYPE_SFD		=	7	; System FCB Descriptor.
SPE_TYPE_DPB		=	8	; Disk parameter block.
SPE_TYPE_SHTE		=	9	; System Handle Table Entry.
SPE_TYPE_SDTE		=	10	; System Drive Table Entry.
SPE_TYPE_SHT		=	11	; System Handle Table itself.
SPE_TYPE_SDT		=	12	; System Drive Table itself.
SPE_TYPE_PRINT_QUEUE	=	13	; Task-Time Spooler Print Queue.
SPE_TYPE_PREFIX         =	14	; prefix string for drive.
SPE_TYPE_FLR		=	15	; FAT Lock Record.
SPE_TYPE_FMT		=	16	; FAT Mapping Table.
SPE_TYPE_FCE		=	17	; FAT Cache Entry.
SPE_TYPE_THREAD         =	18	; Thread Object.
SPE_TYPE_OBJECT         =	19	; Named Object.
SPE_TYPE_LIMIT		=	20	; values at this or above are invalid.
