//***	QUADINT.H -- Quadword Integer API.
//
//1.	Functional Description.
//	This include file contains prototypes for the QUADINT math package.
//
//2.	Modification History.
//	S. E. Jones	93/03/12.	#1.101, original.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1993-1995 General Software, Inc.

#ifndef _QUADINT_API
#define _QUADINT_API

//
// This module depends on KTYPES.
//

#include "..\inc\ktypes.h"		// conditionally includes types.

typedef struct _QUADINT {
    ULONG Low32;			// least-significant 32-bits.
    ULONG High32;			// most-significant 32-bits.
} QUADINT, *PQUADINT;

extern VOID QuadInc (PQUADINT Quadword);

extern VOID QuadDec (PQUADINT Quadword);

extern VOID QuadClear (PQUADINT Quadword);

extern VOID QuadAdd (PQUADINT Destination, PQUADINT Source);

extern VOID QuadSub (PQUADINT Destination, PQUADINT Source);

extern VOID QuadCopy (PQUADINT Destination, PQUADINT Source);

extern VOID QuadAddLong (PQUADINT Destination, ULONG Source);

extern VOID QuadSubLong (PQUADINT Destination, ULONG Source);

#endif // not defined, _QUADINT_API
