;***	PSP.INC -- Embedded DOS Program Segment Prefix.
;
;1.	Functional Description.
;	This structure defines the layout of a PSP, which is built whenever
;	a .COM or .EXE program is loaded into memory.  In essence, this
;	structure is the process control block for the running program. It
;	contains a virtual handle translation table of 20 entries, which
;	contain indexes into the system-wide DOS Handle Table (DHT).  This
;	layout was derived from the information in Ray Duncan's "Advanced
;	MS-DOS" book, published by Microsoft Press.  Additional information
;	was derived from notes of various hackers who left valuable info
;	on public bulletin boards.
;
;	We use the SEGMENT AT 0 model instead of STRUC because we will
;	always have a PSP at a 0 offset, and so we just use ASSUME ES:PSP.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release, added critsave.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

DOSFILELIMIT	=	20
DOSFILEUNUSED	=	0ffh		; byte stored in psp_filetbl if unused.

PSP		SEGMENT AT 0
psp_int20	db	2 dup (?)	; INT 20h instruction (0cdh, 020h).
psp_loadsize	dw	?		; seg FWA, 1st para after this load.
		db	?		; RESERVED.
psp_farcall	db	5 dup (?)	; far call to DOS for CP/M compat.
psp_exit	dd	?		; DOS exit handler (int 22h).
psp_ctrlc	dd	?		; DOS ctrlc handler (int 23h).
psp_criterr	dd	?		; DOS critical error handler (int 24h).
psp_parentPSP	dw	?		; seg adr, parent PSP.
psp_filetbl	db	DOSFILELIMIT dup (?)
psp_environ	dw	?		; seg adr, environment area.
psp_critsave	dw	?		; reserved area for DOSAPI.ASM (crit errs).
		db	2 dup (?)	; RESERVED.
psp_handlelimit dw	?		; number of handles in file table.
psp_pfiletbl	dd	?		; FWA, psp_filetbl or its alternate.
psp_childPSP	dw	?		; seg adr, child PSP.

;	The following fields are reserved by Embedded DOS to store the target
;	CS:IP and SS:SP for the image.

psp_targetip	dw	?		; new IP.
psp_targetcs	dw	?		; new CS.
psp_targetsp	dw	?		; new SP.
psp_targetss	dw	?		; new SS.
psp_targetax	dw	?		; new AX (count of drives, etc.)

;	The following fields are reserved for Embedded DOS.  DosExec needs a
;	way to save the parent's SS:SP register pair during the loading
;	process before jumping to the image.  That's what these fields
;	are for.  By default, if the user doesn't modify the termination
;	address, our ISR20 code will load the parent's stack from these
;	fields and issue a RETN instruction.  This will seem to the user
;	like he just called function 4bh and it returned.  Caution, these
;	fields are stored in the PARENT's PSP, not the child's.

psp_savesp	dw	?		; saved SP (offset stored 1st).
psp_savess	dw	?		; saved SS.
psp_status	dw	?		; status code returned by 4ch.

;	Here's the information used by the extended error function,
;	DosGetExtError.

psp_exterr	dw	?		; extended error.
psp_errclass	db	?		; error class.
psp_erraction	db	?		; suggested action.
psp_errlocus	db	?		; error locus.
		db	?		; RESERVED.

;	The following field is used by some apps to call DOS without an INT
;	instruction.  This is completely silly, but we have to support it.

psp_portcall	db	3 dup (?)	; INT 21h, RETF (0cdh, 021h, 0cbh).
		db	9 dup (?)	; RESERVED.

;	Now the hard stuff that the user must fiddle with.

psp_fcb1	db	16 dup (?)	; WARNING: will overlay FCB2 if opened!
psp_fcb2	db	16 dup (?)	; second FCB (not entirely big enough).
		db	4 dup (?)	; RESERVED.
psp_cmdlen	db	?		; length of command string.
psp_cmdstr	db	127 dup (?)	; command tail itself.

PSPLEN		=	($-psp_int20)
PSP		ENDS

		.errnz	 PSPLEN-256	; the PSP always has to be 256 bytes.
