;***	IOAPI.INC -- Embedded DOS I/O API Definitions for Assembly Language.
;
;1.	Functional Description.
;	This include file defines function codes for the FSD, I/O helpers,
;	and F/S helpers.
;
;2.	Modification History.
;	S. E. Jones	92/09/04.	#1.100, consolidated defines here.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	94/11/10.	#2.2, added REGISTER/DEREGISTER cache fns.
;	S. E. Jones	94/11/10.	#2.2, added SUBMIT_IORP function.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

;	IO-Help function codes.

IOHELP_OPEN	=	0
IOHELP_CLOSE	=	1
IOHELP_CREATE	=	2
IOHELP_DELETE	=	3
IOHELP_READ	=	4
IOHELP_WRITE	=	5
IOHELP_SEEK	=	6
IOHELP_RENAME	=	7
IOHELP_FINDFIRST=	8
IOHELP_FINDNEXT =	9
IOHELP_FILECONTROL =	10
IOHELP_COMMITFILE =	11
IOHELP_FILEINFO =	12
IOHELP_FILETIME =	13
IOHELP_FSINFO	=	14
IOHELP_LOCK	=	15
IOHELP_UNLOCK	=	16
IOHELP_MAX_FUNCTION =	(IOHELP_UNLOCK) ; maximum function code value.

;	FS-Help function codes.

FSHELP_GETDOSDATA =	0		; return (DS) = DOSDATA segment.
FSHELP_GETBPB	=	1		; return BPB address.
FSHELP_READSECTORS =	2		; read sector run from disk.
FSHELP_WRITESECTORS =	3		; write sector run to disk.
FSHELP_REGISTER_FILE_SYSTEM = 4         ; register file system type.
FSHELP_DEREGISTER_FILE_SYSTEM = 5	; deregister file system type.
FSHELP_REGISTER_CACHE = 6		; register cache manager.
FSHELP_DEREGISTER_CACHE = 7		; deregister cache manager.
FSHELP_SUBMIT_IORP =	8		; submit IORP to driver.
FSHELP_MAX_FUNCTION =	(FSHELP_SUBMIT_IORP) ; max func code value.

;	Installable File System (FSD) function codes.

FSD_INITIALIZE	=	0
FSD_SHUTDOWN	=	1
FSD_READFILE	=	2
FSD_WRITEFILE	=	3
FSD_OPENFILE	=	4
FSD_CLOSEFILE	=	5
FSD_CREATEFILE	=	6
FSD_DELETEFILE	=	7
FSD_CREATEDIR	=	8
FSD_DELETEDIR	=	9
FSD_RENAMEFILE	=	10
FSD_SEEKFILE	=	11
FSD_FINDFIRST	=	12
FSD_FINDNEXT	=	13
FSD_SYNCHRONIZE =	14
FSD_FILECTRL	=	15
FSD_FILEINFO	=	16		; get/set file attributes.
FSD_FILETIME	=	17		; get/set file date/time stamp.
FSD_QFSINFO	=	18		; query file system information.
FSD_LOCK	=	19		; lock byte range.
FSD_UNLOCK	=	20		; unlock byte range.
FSD_LIMIT	=	FSD_UNLOCK	; last possible command code.

;	FSD_FILECTRL subfunction codes.

FSCTL_LIMIT	=	0

;	Bitflags for file system driver capabilities.

FSCAPABILITY_UNC	=	0001h	; this FSD supports UNC filenames.
FSCAPABILITY_DFS	=	0002h	; this FSD supports DFS filenames.
