	TITLE	SIMPLE - Simple Interface Test Program.

;***	SIMPLE -- Simple Interface Test Program.
;
;1.	Functional Description.
;	This program illustrates how to call Embedded DOS kernel services
;	from an assembly-language program.  It has no output; it simply
;	calls the PassTimeSlice kernel function to show how to access
;	kernel services.
;
;2.	Modification History.
;	S. E. Jones	93/09/18.	#1.106, original.
;
;3.	NOTICE: Copyright (C) 1993 General Software.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

	include ..\inc\usegs.inc
	include ..\inc\udefines.inc
	include ..\inc\umacros.inc
	include ..\inc\ustruc.inc

;	Kernel definitions.

	include ..\inc\kernel.inc

;	DOS call definitions.

	include ..\inc\dosapi.inc
	include ..\inc\doserr.inc

;	Define the stack.

_STACK	SEGMENT PARA STACK 'STACK'
	db	512 dup ('$')
TopStack =	$
_STACK	ENDS

UCODE	SEGMENT

;***	Main - Main Entrypoint.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is the entrypoint of the test program.  We call
;	the kernel function, PassTimeSlice, and then exit to DOS.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/09/18.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Main, PUBLIC, FAR
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP		; (DS) = DGROUP.

;	Execute a PASS TIME SLICE kernel function.  The function code
;	is passed through the DL register.  Other operands are passed
;	in other registers according to the specifications in the
;	Embedded DOS Technical Reference Manual.

	mov	dl, SYS_PASS_TIME_SLICE
	int	SYSINT			; same as INT 2dh.

;	Now terminate the program, returning to Embedded DOS.

	mov	ah, DOSEXIT
	mov	al, 0			; successful status code.
	int	21h			; terminate program.
EndProc Main

UCODE	ENDS
	END	Main
