/*
// PROGRAM NAME:  QUEUE.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program is a simple example of how the executive queueing
//	functions can be called from large-model C applications.  The program
//	creates a queue and opens it with another handle, simulating a
//	second program that wishes to communicate with the first one.  Then,
//	a data item is pushed to the first handle, and popped from the second
//	handle.
//
// MODIFICATION HISTORY.
//	S. E. Jones	93/09/18.	#1.106, original.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE ARGUMENTS.
//	none.
//
// NOTICE:  Copyright (C) 1993-1995 General Software, Inc.
*/

#define VOID void
#define UCHAR unsigned char
#define USHORT unsigned short
#define ULONG unsigned long
#define FALSE 0
#define TRUE (!FALSE)

#include <stdio.h>

#include "..\inc\queue.h"	// queue API definitions.

static ULONG DataToWrite;
static ULONG DataFromQueue;

VOID main (int argc, char *argv[])
{
    HANDLE Handle1, Handle2;
    USHORT len, i;

    printf ("This is a simple C program that uses queues.\n");

    if (!ExCreateQueue ("My$Queue", &Handle1)) {
	printf ("The My$Queue queue could not be created.\n");
	exit (-1);
    }

    if (!ExOpenQueue ("My$Queue", &Handle2)) {
	ExCloseQueue (Handle1);
	printf ("The My$Queue port could not be opened.\n");
	exit (-1);
    }

    if (!ExPushQueue (Handle1, (PVOID)DataToWrite)) {
	ExCloseQueue (Handle1);
	ExCloseQueue (Handle2);
	printf ("The datum could not be pushed on the queue.\n");
	exit (-1);
    }

    if (!ExPopQueue (Handle2, (PVOID *)&DataFromQueue)) {
	ExCloseQueue (Handle1);
	ExCloseQueue (Handle2);
	printf ("The datum could not be popped from the queue.\n");
	exit (-1);
    }

    //
    // Compare what we sent with what we received.
    //

    if (DataToWrite != DataFromQueue) {
	ExCloseQueue (Handle1);
	ExCloseQueue (Handle2);
	printf ("The datum was garbled.\n");
	exit (-1);
    }
    printf ("The datum was successfully pushed & popped.\n");

    //
    // Clean up and return to DOS.
    //

    ExCloseQueue (Handle1);	// close the queue handles.
    ExCloseQueue (Handle2);
    exit (0);			// successfully return to Embedded DOS.
} // queue.c
