/*****************************************************************************
*
*   Title:        DH485 API Header
*
*   Abstract:     This file contains definitions and declarations
*                 needed for developing applications which use the
*                 DH485 API on the MVI series of products.
*
*
*   Environment:  MVI Communications Module
*                 Borland/Microsoft C/C++ Compiler
*                 General Software Embedded DOS 6-XL
*
*   Author:       TEJ/JJW
*                 Copyright (c) 2000 Online Development, Inc.
*
*****************************************************************************/

#ifndef _MVIDH485API_H
#define _MVIDH485API_H

/***********************************
**      TYPE DEFINITIONS
************************************/
typedef unsigned char   BYTE;       // 8-bit unsigned value
typedef unsigned short  WORD;       // 16-bit unsigned value
typedef unsigned long   DWORD;      // 32-bit unsigned value
typedef unsigned short  MVIHANDLE;  // API handle

/************************************
**   COMMON MVI API RETURN CODES
*************************************/
#define MVI_SUCCESS                    0      /* Function returned successfully         */
#define MVI_ERR_BADPARAM               1      /* A parameter is invalid                 */
#define MVI_ERR_REOPEN                 2      /* Device is already open                 */
#define MVI_ERR_NODEVICE               3      /* Device is not present                  */
#define MVI_ERR_NOACCESS               4      /* Invalid access                         */
#define MVI_ERR_TIMEOUT                5      /* The function has timed out             */
#define MVI_ERR_BADCONFIG              7      /* Unable to configure the requested port */
#define MVI_ERR_MEMALLOC               8      /* Unable to allocate memory              */

/************************************
**  DH485 API SPECIFIC RETURN CODES
*************************************/
#define MVI_ERR_NOT_MASTER             0x0800 /* Command only allowed in master mode    */
#define MVI_ERR_TXCMD_BUSY             0x0801 /* Tx Command already active              */

#define MVI_ERR_RM_MSGTIMEOUT          0x0802 /* Error, message request                 */
                                              /*     timed out                          */
#define MVI_ERR_MEM_ALLOC              0x0803 /* Error, uunable to allocate             */
                                              /*    memory for request                  */

#define MVI_ERR_ILL_CMD_FMT            0x0804 /* Illegal command or format              */
#define MVI_ERR_HARDWARE_FLT           0x0805 /* Host couldn't complete,                */
                                              /*    hardware fault                      */
#define MVI_ERR_ADDRESS_PROBLEM        0x0806 /* Out of memory, file or                 */
                                              /*      rung dosen't exist                */
                                              /* Illegal Address                        */
#define MVI_ERR_ILL_ADDR_VAL           0x0807 /*    field has illegal value             */
#define MVI_ERR_ILL_ADDR_MISSING_FLD   0x0808 /*    not enough fields                   */
#define MVI_ERR_ILL_ADDR_EXCESS_FLD    0x0809 /*    too many fields                     */
#define MVI_ERR_ILL_ADDR_SYM_NOT_FOUND 0x080A /*    symbol not found                    */
#define MVI_ERR_ILL_ADDR_BAD_SYMBOL    0x080B /*    symbol 0 or greater                 */
                                              /*       then max char                    */
#define MVI_ERR_ILL_ADDR_DOESNT_EXIST  0x080C /*    doesn't exist                       */

                                              /* Illegal Size                           */
#define MVI_ERR_ILL_SIZE               0x080D /*    file wrong size, addr               */
                                              /*    past end of file                    */

#define MVI_ERR_MEM_UNAVAIL            0x080E /* Data or file too large,                */
                                              /*    memory unavailable                  */
#define MVI_ERR_REQ_TOO_BIG            0x080F /* Request too large, trans.              */
                                              /*    size + addr. too large              */
#define MVI_ERR_ACCESS_DENIED          0x0810 /* Access denied                          */
#define MVI_ERR_CMD_EXECUTION          0x0811 /* Cmd can't be executed                  */

#define MVI_ERR_ILL_DATA_TYPE          0x0812 /* Illegal data type info                 */
#define MVI_ERR_ILL_PARM               0x0813 /* Illegal parameter; invalid             */
                                              /* data in search or cmd block            */

#define MVI_ERR_FILE_OPEN              0x0814 /* File open by another node              */
#define MVI_ERR_PROGRAM_OWNED          0x0815 /* Program owned by another               */
                                              /*    node                                */
#define MVI_ERR_UNKNOWN_ERR_CODE       0x0816 /* Unknown error returned                 */
                                              /* from host                              */

/***********************************
**  MVI DH485 PORT DEFINITIONS
**
**    Used by the MVIdh_Open function.
************************************/
#define     MVI_COM2          1
#define     MVI_COM3          2

/************************************
**  MVI DH485 BAUD RATES
**
**    Used by the MVIdh_Open function.
*************************************/
#define     MVI_BAUD_1200     4
#define     MVI_BAUD_2400     5
#define     MVI_BAUD_9600     7
#define     MVI_BAUD_19200    8

/************************************
**  MVI DH485 MAX NODE NUMBER
**
**    Used by the MVIdh_Open function.
*************************************/
#define MVI_MAX_NODE_NUM  31

/************************************
**  MVI DH485 DEVICE MODES
**
**    Used by the MVIdh_Open function.
*************************************/
#define MVI_MODE_SLAVE    0
#define MVI_MODE_MASTER   2

/************************************
**  DH485 LED STATUS DEFINITIONS
**
**    These values are used by the
**    MVIdh_GetLEDState function.
*************************************/
#define MVI_LED_STATE_OFF   0           // LED is OFF
#define MVI_LED_STATE_ON    1           // LED is ON

/************************************
**  DH485 COMMUNICATIONS STATUS
**  DEFINITIONS
**
**    These values are used by the
**    MVIdh_GetCommStatus function.
*************************************/
#define MVI_COMM_STATUS_OFF   0         // Comm Link is OFF-Line
#define MVI_COMM_STATUS_ON    1         // Comm Link is ON-Line

/************************************
**  DH485 COMMON INTERFACE FILE
**  DEFINITIONS
**
**    These values are used by the
**    functions:
**    MVIdh_GetDataFromCIF
**    MVIdh_PutDataToCIF
*************************************/
#define MVI_MAXCIFDATASIZE    244

/************************************
**  DH485 COMMON INTERFACE FILE
**  STATUS DEFINITIONS
**
**    These values are used by the
**    functions:
**    MVIdh_CheckCIFRdStatus
**    MVIdh_CheckCIFWrStatus
*************************************/
#define MVI_CIF_NOTACCESSED   0       // CIF has not been accessed since last checked
#define MVI_CIF_ACCESSED      1       // CIF has been accessed since last checked

/************************************
**  DH485 API FUNCTION PARAMETERS
**    These are used in the functions:
**    MVIdh_WriteRemoteDataFile
**    MVIdh_ReadRemoteDataFile
*************************************/
#define MVI_FILETYPE_STATUS        0x84  // 132
#define MVI_FILETYPE_BIT           0x85  // 133
#define MVI_FILETYPE_TIMER         0x86  // 134
#define MVI_FILETYPE_COUNTER       0x87  // 135
#define MVI_FILETYPE_CONTROL       0x88  // 136
#define MVI_FILETYPE_INTEGER       0x89  // 137


/************************************
**  VERSION INFORMATION STRUCT
*************************************/
typedef struct tagDH485VERSIONINFO
{
    WORD    APISeries;
    WORD    APIRevision;
} DH485VERSIONINFO;

/************************************
**  DH485CONFIG STRUCT
*************************************/
typedef struct tagDH485CONFIG
{
    int     comport;        /* COM2, COM3 */
    BYTE    baudrate;       /* BAUD_1200 - BAUD_19200 */
    BYTE    node;           /* Valid nodes are 0 - 31 */
    BYTE    mode;           /* 0 = slave, 2 = master */
} DH485CONFIG;

/*************************************
**  DH485 API FUNCTION PROTOTYPES
*************************************/

/* Define a convenient macro for library function declarations */

#ifdef __cplusplus
#define MVIAPIENTRY extern "C" int pascal
#define MVIAPIENTRYW extern "C" WORD pascal
#else
#define MVIAPIENTRY int pascal
#define MVIAPIENTRYW WORD pascal
#endif

MVIAPIENTRY MVIdh_Open( MVIHANDLE *handle, DH485CONFIG *dh485cfg );
MVIAPIENTRY MVIdh_Close( MVIHANDLE handle );
MVIAPIENTRY MVIdh_ErrorString( int errcode, char *buf );
MVIAPIENTRY MVIdh_GetVersionInfo( MVIHANDLE handle, DH485VERSIONINFO *verinfo );
MVIAPIENTRY MVIdh_GetANTable( MVIHANDLE handle, DWORD *ANTable );
MVIAPIENTRY MVIdh_GetCommStatus( MVIHANDLE handle, BYTE *bStatus);
MVIAPIENTRY MVIdh_GetLedState( MVIHANDLE handle, BYTE *bState);
MVIAPIENTRY MVIdh_GetDataFromCIF( MVIHANDLE handle, WORD offset, WORD dataSize, BYTE *dataBuf );
MVIAPIENTRY MVIdh_PutDataToCIF( MVIHANDLE handle, BYTE *dataBuf, WORD offset, WORD dataSize );
MVIAPIENTRY MVIdh_CheckCIFRdStatus( MVIHANDLE handle, BYTE *bStatus );
MVIAPIENTRY MVIdh_CheckCIFWrStatus( MVIHANDLE handle, BYTE *bStatus );
MVIAPIENTRY MVIdh_WriteRemoteCIFFile( MVIHANDLE handle, BYTE *dataBuf, WORD node, WORD offset, WORD dataSize, WORD timeout );
MVIAPIENTRY MVIdh_ReadRemoteCIFFile( MVIHANDLE handle, WORD node, WORD offset, WORD dataSize, BYTE *dataBuf, WORD timeout );
MVIAPIENTRY MVIdh_WriteRemoteDataFile( MVIHANDLE handle, BYTE *dataBuf, BYTE node, BYTE dataSize, WORD fileNum, BYTE fileType, WORD Element, WORD timeout );
MVIAPIENTRY MVIdh_ReadRemoteDataFile( MVIHANDLE handle, BYTE node, BYTE dataSize, WORD fileNum, BYTE fileType, WORD Element, BYTE *dataBuf, WORD timeout );


#endif

