;***	MCB.INC -- Embedded DOS Memory Control Block.
;
;1.	Functional Description.
;	This segment defines a Memory Control Block, or arena header
;	as it is called in the DOS literature, which describes a block
;	of memory which follows starting at the very next paragraph.
;
;	The arena header used by MS-DOS is partially publically known.
;	Many programs depend upon the partial public-domain knowlege of
;	this private data structure to walk the arena and even determine
;	how large an arena item is.  Here is the basic MS-DOS arena header:
;
;	ARENAHEADER		struc
;	arenaheader_sig         db	?	; 4dh for not at end, 5ah at end.
;	arenaheader_psp         dw	?	; seg FWA, owning PSP, or 0 if free.
;	arenaheader_size	dw	?	; paragraphs described by this hdr.
;	arenaheader_reserved	db	11 dup (0) ; padding.
;	ARENAHEADER		ends
;
;	In order to accommodate programs that depend on the MS-DOS arena header,
;	we emulate the signature, and actually use the psp and size fields.  In
;	actually managing the memory arena, we use fwdlink, baklink, and other
;	fields that are not a part of the MS-DOS arena header.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

MCB		SEGMENT AT 0
mcb_ah_sig	db	?		; type of block (READ-ONLY).
mcb_psp         dw	?		; seg FWA, owning PSP, or 0 if unused.
mcb_size	dw	?		; user chunk size (excl MCB), paragraphs.
		db	?		; word alignment for performance reasons.

;	The following fields are NOT compatible with MS-DOS's arena header.

mcb_fwdlink	dw	?		; segment of next MCB.
mcb_baklink	dw	?		; segment of previous MCB.
mcb_reserved	dw	3 dup (?)	; reserved area.
MCB		ENDS

MCB_AH_SIG_VALID =	4dh		; arena block is valid first or middle block.
MCB_AH_SIG_END	 =	5ah		; arena block is last one in arena.
