;***	DEVAPI.INC -- Device Driver API Definitions for Assembly Language.
;
;1.	Functional Description.
;	This include file defines function codes for the Device Driver API.
;	Status codes are in DEVERR.INC.  We also have OS/2 codes here because
;	some embedded projects use both OS/2 2.0 and Embedded DOS.
;
;2.	Modification History.
;	S. E. Jones	92/09/04.	#1.100, consolidated defines here.
;	S. E. Jones	92/11/19.	#1.101, added OS/2 1.3 (Tiger) DD funcs.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

DEV_INITIALIZE	=	0		; initialize driver.
DEV_MEDIA_CHECK =	1		; media check on block device.
DEV_BUILD_BPB	=	2		; build BIOS Parameter Block.
DEV_IOCTL_READ	=	3		; I/O Control read.
DEV_READ	=	4		; read from device.
DEV_ND_READ	=	5		; non-destructive read.
DEV_INPUT_STATUS=	6		; return current input status.
DEV_INPUT_FLUSH =	7		; flush device input buffer.
DEV_WRITE	=	8		; write to device.
DEV_WRITE_VFY	=	9		; write with verify.
DEV_OUTPUT_STATUS=	10		; return current output status.
DEV_OUTPUT_FLUSH=	11		; flush device output buffer.
DEV_IOCTL_WRITE =	12		; I/O Control write.
DEV_OPEN	=	13		; device open.
DEV_CLOSE	=	14		; device close.
DEV_REMOVE_MEDIA=	15		; removable media.
DEV_OUTPUT_BUSY =	16		; output until busy.
DEV_GENERIC_IOCTL =	19		; generic IOCTL function.
DEV_GET_LOGICAL_DEVICE= 23		; get logical device mapping.
DEV_SET_LOGICAL_DEVICE= 24		; set logical device mapping.
DEV_LIMIT	=	DEV_SET_LOGICAL_DEVICE ; last possible command code.

;	OS/2 device function codes.

OS2DEV_INITIALIZE  =	   0		; initialize driver.
OS2DEV_MEDIA_CHECK =	   1		; media check on block device.
OS2DEV_BUILD_BPB   =	   2		; build BIOS Parameter Block.
OS2DEV_IOCTL_READ  =	   3		; I/O Control read.
OS2DEV_READ	   =	   4		; read from device.
OS2DEV_ND_READ	   =	   5		; non-destructive read.
OS2DEV_INPUT_STATUS=	   6		; return current input status.
OS2DEV_INPUT_FLUSH =	   7		; flush device input buffer.
OS2DEV_WRITE	   =	   8		; write to device.
OS2DEV_WRITE_VFY   =	   9		; write with verify.
OS2DEV_OUTPUT_STATUS=	   10		; return current output status.
OS2DEV_OUTPUT_FLUSH=	   11		; flush device output buffer.
OS2DEV_IOCTL_WRITE =	   12		; I/O Control write.
OS2DEV_OPEN	   =	   13		; device open.
OS2DEV_CLOSE	   =	   14		; device close.
OS2DEV_REMOVE_MEDIA=	   15		; removable media.
OS2DEV_GENERIC_IOCTL =	   16		; generic IOCTL function.
OS2DEV_RESET_MEDIA_UNCERTAIN = 17	; reset uncertain media.
OS2DEV_GET_LOGICAL_DEVICE= 18		; get logical device mapping.
OS2DEV_SET_LOGICAL_DEVICE= 19		; set logical device mapping.
OS2DEV_DEINSTALL =	20		; deinstall device driver.
OS2DEV_PARTITION_DISK = 22		; partition fixed disks.
OS2DEV_CACHE_BYPASS_READ = 24		; cache bypass read data.
OS2DEV_CACHE_BYPASS_WRITE = 25		; cache bypass write data.
OS2DEV_CACHE_BYPASS_WRITEV = 26         ; cache bypass write & verify.
OS2DEV_INIT_BASE	= 27		; init base device driver.
OS2DEV_SHUTDOWN =	28		; shutdown machine.
OS2DEV_GET_DEV_SUPPORT = 29		; query for extended capabilities.
OS2DEV_LIMIT = OS2DEV_GET_DEV_SUPPORT	; last possible command code.
