;***	DBPB.INC -- Embedded DOS Driver BIOS Parameter Block.
;
;1.	Functional Description.
;	This include file contains the format of a Driver BIOS Parameter
;	Block as used in the disk driver (NOT the BPB in the boot record).
;
;2.	Modification History.
;	S. E. Jones	91/07/14.	#1.086, split off from BPB.
;	S. E. Jones	93/09/26.	#2.000, release.
;	C. S. Rhodes	94/11/10.	#2.2, added change line support flag.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

DBPB		struc
dbpb_BPB	db	(SIZE BPB) dup (?) ; a BPB at the same address.

;	The following fields are private extensions for the disk driver.

dbpb_spcyl	dw	?		; sectors per cylinder, calculated.
dbpb_DriveNo	db	?		; BIOS drive number for this unit.
dbpb_TimeStamp	dw	?		; last time we referenced this drive.
dbpb_Valid	dw	?		; 0=re-read BPB, 1=BPB valid.
dbpb_ClSupport	dw	?		; 0=no change line, 1=change line support.

;	DPT values to be stored right before doing I/O to this disk.

dbpb_dpt_spt	db	?		; sectors per track.
dbpb_dpt_gap	db	?		; gap length between sectors.
dbpb_dpt_gapf	db	?		; gap length for format.
dbpb_dpt_settle db	?		; head settle time after seeks.
dbpb_dpt_start	db	?		; motor start time before I/O.

;	The following (extended BPB) field is used internally in the disk
;	driver to remember the true hidden sectors in front of this partition.
;	The number stored in bpb_HS represents the number of sectors starting
;	at the cylinder boundary of the partition and ending with the first
;	reachable sector in the partition.  Thus, bpb_HS is usually 17 for
;	a 17-spt ST-506 drive, regardless of which partition it is, but
;	bpb_PartStart is typically large (although it is equal to bpb_HS for
;	the first partition on the disk.)

dbpb_PartOfs	dd	?		; logical->absolute sector offset.

;	The following (extended BPB) field is used internally in the disk
;	driver as a BIAS on ReadTrack, WriteTrack, FormatTrack, and VerifyTrack
;	generic IOCTL functions.  This allows the application program (such
;	as FORMAT, CHKDSK, SYS, etc.) to address partition-relative sectors
;	without knowing the partition layout scheme.  This value is 0 on
;	floppy disks because they don't get partitioned.

dbpb_StartCyl	dw	?		; 1st cylinder of partition.

DBPB		ends

DBPB_DPT_GAP_3INCH	=	1bh	; gap length for a 3.5" floppy.
DBPB_DPT_GAP_5INCH	=	2ah	; gap length for a 5.25" floppy.

DBPB_DPT_GAPF_3INCH	=	6ch	; format gap length for 3.5" floppy.
DBPB_DPT_GAPF_5INCH	=	50h	; format gap length for 5.25" floppy.

DBPB_DPT_SETTLE_3INCH	=	0fh	; head settle time for 3.5" floppy.
DBPB_DPT_SETTLE_12MB	=	0fh	; head settle time for 1.2Mb floppies.
DBPB_DPT_SETTLE_360K	=	25	; head settle time for 360k floppies.

DBPB_DPT_START_READ	=	05h	; 1/2 second for reads and verifies only.
DBPB_DPT_START_NORMAL	=	08h	; about 1 second for all other operations.
