/*---------------------------------------------------------------------------
**
**	ADMAPI.H
**
**	Title:			MVI-ADM Communications Module API Definitions
**
**	Abstract:		This file contains definitions and declarations
**					needed in order to use the ADMAPI.LIB library
**					functions.  Include this file in all modules
**					that call the ADMAPI functions.
**
**	Environment:	MVI Communications Module
**					Borland C/C++ Compiler
**                 	General Software Embedded DOS 6-XL
**
**	Author:
**
**	Richard A. Reynolds
**	(c) 1999, Vital Computer Solutions, All Rights Reserved
**
**	Ken D. Hopwood
**	(c) 2000-2004, ProSoft Technologies, Inc., All Rights Reserved
**
**	Sukhum Amorntrakul (Joe)
**	(c) 2002-2003, ProSoft Technologies, Inc., All Rights Reserved
**
**	Incorporates code from 05/20/1999
**
**	MODIFIED :
**
**		12/05/2000 - 03/03/2001 -- Created API code from existing works.
**		03/13/2001 -- added cbuff to ADM_BT_DATA; increased size of wrbuff
**						in ADM_BT_DATA.  Added Apperr to interface struct.
**		03/28/2001 -- Added console functions.
**		09/28/2004 -- Added support for MVI69
**
**
**
** ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
** and re-distribute this program provided that this copyright notice and
** license appear on all copies of the software.
**
** Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
** IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
** HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
** BY THE LICENSEE.
**
** PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
** DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
** DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
** ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
**
**
**---------------------------------------------------------------------------
*/

#ifndef _ADMAPI_H
#define _ADMAPI_H


/*---------------------------------------------------------------------------
**	CONSTANT DEFINITIONS
**---------------------------------------------------------------------------
*/

/* Set platfom type */
//#define MVI56
//#define MVI46
//#define MVI94
//#define MVI71
#define PTQ
//#define PLX
//#define MVI69

/*-------------------------------------------------------------------------*/
/* Module definitions -- do not edit */

#if defined(MVI46)
#	define MAX_APP_PORTS	   2   				/* maximum number of application ports */
#	define ADM_MAX_DB_REGS  10000
#	define BP_CFG_REGS      5000
#	define PORT1_SET_REGS   5010
#	define PORT2_SET_REGS   5020
#elif defined(MVI56)
#	define MAX_APP_PORTS	   2   				/* maximum number of application ports */
#	define ADM_MAX_DB_REGS  7000
#	define BP_CFG_REGS      5000
#	define PORT1_SET_REGS   5010
#	define PORT2_SET_REGS   5020
#elif defined(MVI71)
#	define MAX_APP_PORTS	   2   				/* maximum number of application ports */
#	define ADM_MAX_DB_REGS  10000
#	define BP_CFG_REGS      5000
#	define PORT1_SET_REGS   5010
#	define PORT2_SET_REGS   5020
#elif defined(MVI94)
#	define MAX_APP_PORTS	   1   				/* maximum number of application ports */
#	define ADM_MAX_DB_REGS  3996
#elif defined(PTQ)
#	define MAX_APP_PORTS	   2   				/* maximum number of application ports */
# if defined(BIGIO)
#	define ADM_MAX_DB_REGS  4000
#else
#	define ADM_MAX_DB_REGS  10000
#endif
#	define BP_CFG_REGS      5000
#	define PORT1_SET_REGS   5010
#	define PORT2_SET_REGS   5020
#elif defined(PLX)
#	define MAX_APP_PORTS	   4   				/* maximum number of application ports */
#	define ADM_MAX_DB_REGS  10000
#	define PORT_LED_PORT  	0x208         //out port for serial port LED's
#	define SER_PORT_SET   	0x218         //out port address for interface control
#elif defined(MVI69)
#	define MAX_APP_PORTS	   2   				/* maximum number of application ports */
#	define ADM_MAX_DB_REGS  7000
#	define BP_CFG_REGS      5000
#	define PORT1_SET_REGS   5010
#	define PORT2_SET_REGS   5020
#endif

#define ADM_LED_USER1		1
#define ADM_LED_USER2		2
#define ADM_LED_STATUS		3
#define ADM_LED_OK		   0
#define ADM_LED_FAULT		1
#define ADM_LED_OFF        0
#define ADM_LED_ON         1
#define ADM_LED_PLXOK		2
#define ADM_LED_PCFG			9
#define ADM_LED_P0			10
#define ADM_LED_P1			11
#define ADM_LED_P2			12
#define ADM_LED_P3			13


/*---------------------------------------------------------------------------
**	DEBUG PORT CONSTANT DEFINITIONS
**---------------------------------------------------------------------------
*/

#define RTSOFF			0
#define RTSON			1
#define CTSRCV			2

#define MAIN_MENU       	0
#define USER_MENU       	2


/*---------------------------------------------------------------------------
**      TYPE DEFINITIONS
**---------------------------------------------------------------------------
*/

#ifndef _MVIBPAPI_H
typedef unsigned char   BYTE;       /* 8-bit unsigned value */
typedef unsigned short  WORD;       /* 16-bit unsigned value */
typedef unsigned long   DWORD;      /* 32-bit unsigned value */
typedef unsigned short  MVIHANDLE;  /* API handle */
#endif

#ifndef _MVISCAPI_H
typedef unsigned short  HANDLE;     // API handle
#endif


typedef unsigned short  ADMHANDLE;  			/* API handle */


/*---------------------------------------------------------------------------
**    API FUNCTION RETURN CODES
**---------------------------------------------------------------------------
*/

#define ADM_ERR_NOACCESS	   -1			/* Invalid access */
#define ADM_SUCCESS			   0			/* Function returned successfully */
#define ADM_ERR_BADPARAM      1			/* A parameter is invalid */
#define ADM_ERR_REOPEN			2			/* Device is already open */
#define ADM_ERR_DB_MAX_SIZE	3			/* Database maximum size has been exceeded */
#define ADM_ERR_MEMORY			4			/* Insufficient memory for database */
#define ADM_ERR_REG_RANGE		5			/* Database register is out of range */
#define ADM_ERR_OPEN			   6			/* Database already opened */
#define ADM_ERR_NOTSUPPORTED	7			/* Function is not supported on this platform */

/* end of section */
/*-------------------------------------------------------------------------*/

#define FALSE	0
#define TRUE	1


/*---------------------------------------------------------------------------
**    API FUNCTION POINTER PROTOTYPES
**---------------------------------------------------------------------------
*/

extern int	(*startup_ptr)(void);				/* pointer to function for startup code */
extern int	(*shutdown_ptr)(void);  			/* pointer to function for shutdown code */
extern int 	(*user_menu_ptr)(void);				/* pointer to function for additional menu code */
extern void (*version_ptr)(void);				/* pointer to function for version information */
extern void (*process_cfg_ptr)(void);			/* pointer to function for checking configuration */
extern int (*ctrl_data_block_ptr)(unsigned short);			/* pointer to function for checking configuration */



/*---------------------------------------------------------------------------
**    API STRUCTURE DEFINITIONS
**---------------------------------------------------------------------------
*/

/* ensure structures are word-aligned */
#ifdef __BORLANDC__
#pragma option -a
#endif /* _BORLANDC */

#ifdef _MSC_VER
#pragma pack(2)
#endif /* _MSC_VER */


typedef struct
{
	char			APISeries[4];
	short			APIRevisionMajor;
	short			APIRevisionMinor;
	long			APIRun;
}ADMVERSIONINFO;

typedef struct
{
	char			ProdName[5];               	/* Product Name */
	char			Rev[5];                    	/* Revision */
	char			Op[5];                     	/* Month/Year */
	char			Run[5];                    	/* Day/Run */
}ADM_PRODUCT;


typedef struct
{
   short				init_data;
   short				input_start_reg;
   short				output_start_reg;
	short				rd_start;
	short				rd_count;
	short				rd_blk_max;
	short				wr_start;
	short				wr_count;
	short				wr_blk_max;
	WORD				bt_fail_cnt;			/* number of successive failures before comm SD */
	WORD				bt_fail_cntr;  		/* current number of failures */
	WORD				bt_failed;     		/* comm SD status */
	short				rd_blk;
	short				rd_blk_last;
	short				wr_blk;
	short				wr_blk_last;
	unsigned short	buff[130];      //only require a single buffer because only 1 op at a time
	WORD				wrbuff[258];
	WORD				rdbuff[248];
	WORD				cbuff[3000];
   short				bt_size;
}ADM_BT_DATA;

typedef struct
{
	WORD			rd;
	WORD			wr;
	WORD			parse;
	WORD			event;
	WORD			cmd;
	WORD			err;
}ADM_BLK_ERRORS;

typedef struct
{
	char           	enabled;				/* Y=Yes, N=No */
	char  				interface;    		//0=don't use, 1=RS-232, 2=RS-485, 3=RS-422
	unsigned short 	baud;
	short          	parity;
	short          	databits;
	short          	stopbits;
	unsigned short 	MinDelay;        	/* minimum response delay */
	unsigned short 	RTS_On;
	unsigned short 	RTS_Off;
	char           	CTS;					/* Y=Yes, N=No */
	short             state;
	int               len;      			/* length of data in buffer */
	int               expLen;   			/* expected length of message */
	unsigned long     timeout;  			/* timeout for message */
	int               ComState; 			/* State of serial communication */
	int			      RTULen;
	unsigned short 	tm;
	unsigned short	   tmlast;
	long              tmout;
	long              tmdiff;
	unsigned short 	CurErr;
	unsigned short 	LastErr;
	unsigned short 	CfgErr;
	unsigned short	   buff_ptr;
	char           	buff[4500];
	unsigned char     SendBuff[1000];
	unsigned char     RecBuff[1000];
}ADM_PORT;

typedef struct
{
	char           name[81];
	short          max_regs;
	short          err_offset;
	unsigned short err_freq;
	short          rd_start;
	short          rd_count;
	short          rd_blk_max;
	short          wr_start;
	short          wr_count;
	short          wr_blk_max;
	short          bt_fail_cnt;
}ADM_MODULE;

typedef struct
{
	WORD			CmdList;				   /* Total number of command list requests */
	WORD			CmdListResponses;		/* Total number of command list responses */
	WORD			CmdListErrors;			/* Total number of command list errors */
	WORD			Requests;				/* Total number of requests of slave */
	WORD			Responses;				/* Total number of responses */
	WORD			ErrSent;             /* Total number of errors sent */
	WORD			ErrRec;              /* Total number of errors received */
}ADM_PORT_ERRORS;

typedef struct
{
	ADM_BT_DATA       *adm_bt_data_ptr;				/* pointer to struct holding ADM_BT_DATA */
	ADM_BLK_ERRORS    *adm_bt_err_ptr;     		/* pointer to struct holding ADM_BT_DATA */
	ADM_PORT          *adm_port_ptr[4];		      /* pointer to struct holding ADM_PORT */
	ADM_MODULE		   *adm_module_ptr;				/* pointer to struct holding ADM_MODULE */
	ADM_PORT_ERRORS   *adm_port_errors_ptr[4];	/* pointer to struct holding ADM_PORT_ERRORS */
	ADM_PRODUCT		   *adm_product_ptr;				/* pointer to struct holding ADM_PRODUCT */
	int               (*startup_ptr)(void);  		/* pointer to function for startup code */
	int               (*shutdown_ptr)(void); 		/* pointer to function for shutdown code */
	int               (*user_menu_ptr)(void);		/* pointer to function for additional menu code */
	void              (*version_ptr)(void);		/* pointer to function for version information */
	void              (*process_cfg_ptr)(void);  /* pointer to function for checking configuration */
	int              	(*ctrl_data_block_ptr)(unsigned short);  /* pointer to function for checking configuration */
	unsigned short 	pass_cnt;
	short             debug_mode;
	char              buff[2000];                /* data area used to hold message */
	int               buff_len;                  /* number of characters to print */
	int               buff_ch;                   /* index of character to print */
	MVIHANDLE         handle;                    /* backplane handle */
	HANDLE            sc_handle;                 /* side-connect handle */
	int               ModCfgErr;
	int               Apperr;
   unsigned short    cfg_file;                  /* side-connect usage */
}ADM_INTERFACE;


/* return packing alignment to default */
#ifdef __BORLANDC__
#pragma option -a-
#endif /* _BORLANDC */

#ifdef _MSC_VER
#pragma pack()
#endif /* _MSC_VER */


/*---------------------------------------------------------------------------
**	VARIABLE DEFINITIONS
**---------------------------------------------------------------------------
*/

extern char buff[];						/* data area used to hold message */
extern unsigned char PortLEDState;  //error LED's for serial ports


/*---------------------------------------------------------------------------
**	FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

/* Define macros for library function declarations */

#ifdef __cplusplus
#define ADMAPIENTRYV 	extern "C" void pascal
#define ADMAPIENTRY 	   extern "C" int pascal
#define ADMAPIENTRYIP 	extern "C" int * pascal
#define ADMAPIENTRYW 	extern "C" WORD pascal
#define ADMAPIENTRYUL 	extern "C" DWORD pascal
#define ADMAPIENTRYU 	extern "C" unsigned short pascal
#define ADMAPIENTRYUP 	extern "C" unsigned short * pascal
#define ADMAPIENTRYC 	extern "C" char pascal
#define ADMAPIENTRYUC 	extern "C" unsigned char pascal
#define ADMAPIENTRYCP	extern "C" char * pascal
#define ADMAPIENTRYL 	extern "C" long pascal
#define ADMAPIENTRYF 	extern "C" float pascal
#define ADMAPIENTRYD 	extern "C" double pascal
#define ADMAPIENTRYCHP	extern "C" char huge * pascal
#else
#define ADMAPIENTRYV 	void pascal
#define ADMAPIENTRY 	   int pascal
#define ADMAPIENTRYIP 	int * pascal
#define ADMAPIENTRYW 	WORD pascal
#define ADMAPIENTRYUL 	DWORD pascal
#define ADMAPIENTRYU 	unsigned short pascal
#define ADMAPIENTRYUP 	unsigned short * pascal
#define ADMAPIENTRYUC 	unsigned char pascal
#define ADMAPIENTRYC 	char pascal
#define ADMAPIENTRYCP	char * pascal
#define ADMAPIENTRYL 	long pascal
#define ADMAPIENTRYF 	float pascal
#define ADMAPIENTRYD 	double pascal
#define ADMAPIENTRYCHP	char huge * pascal
#endif


/*---------------------------------------------------------------------------
**	GENERAL LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/
ADMAPIENTRY    ADM_Open(ADMHANDLE * adm_handle);
ADMAPIENTRY    ADM_Close(ADMHANDLE adm_handle);
ADMAPIENTRY    ADM_GetVersionInfo(ADMHANDLE adm_handle,
									   ADMVERSIONINFO* adm_verinfo);
ADMAPIENTRYV	ADM_SetConsolePort(int Port);
ADMAPIENTRY 	ADM_SetConsoleSpeed (int Port, long Speed);
ADMAPIENTRYV   ADM_ColdBoot(void);
ADMAPIENTRY    ADM_InitializeDB(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr);


/*---------------------------------------------------------------------------
**	DATABASE LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

ADMAPIENTRY   	ADM_DBOpen(ADMHANDLE adm_handle, unsigned short max_size);
ADMAPIENTRY   	ADM_DBClose(ADMHANDLE adm_handle);
ADMAPIENTRY   	ADM_DBZero(ADMHANDLE adm_handle);

ADMAPIENTRY   	ADM_DBGetBit(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRY   	ADM_DBSetBit(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRY   	ADM_DBClearBit(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRYC   ADM_DBGetByte(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRY   	ADM_DBSetByte(ADMHANDLE adm_handle, unsigned short offset,
					const char val);
ADMAPIENTRY   	ADM_DBGetWord(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRY   	ADM_DBSetWord(ADMHANDLE adm_handle, unsigned short offset,
					const short val);
ADMAPIENTRYL   ADM_DBGetLong(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRY   	ADM_DBSetLong(ADMHANDLE adm_handle, unsigned short offset,
					const long val);
ADMAPIENTRYF	ADM_DBGetFloat(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRY		ADM_DBSetFloat(ADMHANDLE adm_handle, unsigned short offset,
					const float val);
ADMAPIENTRYD	ADM_DBGetDFloat(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRY   	ADM_DBSetDFloat(ADMHANDLE adm_handle, unsigned short offset,
					const double val);
ADMAPIENTRYCP 	ADM_DBGetBuff(ADMHANDLE adm_handle, unsigned short offset,
					const unsigned short count, char * str);
ADMAPIENTRY   	ADM_DBSetBuff(ADMHANDLE adm_handle, unsigned short offset,
					const unsigned short count, char * str);
ADMAPIENTRYUP 	ADM_DBGetRegs(ADMHANDLE adm_handle, unsigned short offset,
					const unsigned short count, unsigned short * buff);
ADMAPIENTRY   	ADM_DBSetRegs(ADMHANDLE adm_handle, unsigned short offset,
					const unsigned short count, unsigned short * buff);
ADMAPIENTRYCP 	ADM_DBGetString(ADMHANDLE adm_handle, unsigned short offset,
					const unsigned short maxcount, char * str);
ADMAPIENTRY   	ADM_DBSetString(ADMHANDLE adm_handle, unsigned short offset,
					const unsigned short maxcount, char * str);

ADMAPIENTRY   	ADM_DBSwapWord(ADMHANDLE adm_handle, unsigned short offset);
ADMAPIENTRY   	ADM_DBSwapDWord(ADMHANDLE adm_handle, unsigned short offset,
					int type);

ADMAPIENTRYCP 	ADM_GetDBCptr(ADMHANDLE adm_handle, int DBaddress);
ADMAPIENTRYIP 	ADM_GetDBIptr(ADMHANDLE adm_handle, int DBaddress);
ADMAPIENTRY 	ADM_GetDBInt(ADMHANDLE adm_handle, int DBaddress);

ADMAPIENTRY 	ADM_DBChanged(ADMHANDLE adm_handle, int offset);
ADMAPIENTRY 	ADM_DBBitChanged(ADMHANDLE adm_handle, int offset);

ADMAPIENTRY 	ADM_DBOR_Byte(ADMHANDLE adm_handle, int offset,
					unsigned char bval);
ADMAPIENTRY 	ADM_DBNOR_Byte(ADMHANDLE adm_handle, int offset,
					unsigned char bval);
ADMAPIENTRY 	ADM_DBAND_Byte(ADMHANDLE adm_handle, int offset,
					unsigned char bval);
ADMAPIENTRY 	ADM_DBNAND_Byte(ADMHANDLE adm_handle, int offset,
					unsigned char bval);
ADMAPIENTRY 	ADM_DBXOR_Byte(ADMHANDLE adm_handle, int offset,
					unsigned char bval);
ADMAPIENTRY 	ADM_DBNXOR_Byte(ADMHANDLE adm_handle, int offset,
					unsigned char bval);


/*---------------------------------------------------------------------------
**	CLOCK LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

ADMAPIENTRYU	ADM_StartTimer(ADMHANDLE adm_handle);
ADMAPIENTRY 	ADM_CheckTimer(ADMHANDLE adm_handle,
					unsigned short * adm_tmlast, long * adm_tmout);


/*---------------------------------------------------------------------------
**	LED LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

ADMAPIENTRY 	ADM_SetLed(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int led, int state);


/*---------------------------------------------------------------------------
**	BACKPLANE LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

ADMAPIENTRY 	ADM_BtOpen(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int verbose);
ADMAPIENTRY 	ADM_BtClose(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr);
ADMAPIENTRY 	ADM_BtNext(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr);
ADMAPIENTRY 	ADM_ReadBtCfg(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int verbose);
ADMAPIENTRY 	ADM_BtFunc(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int verbose);
ADMAPIENTRY 	ADM_SetStatus(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int pass_cnt);
ADMAPIENTRY 	ADM_SetBtStatus(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int pass_cnt);


/*---------------------------------------------------------------------------
**	SIDE-CONNECT LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

ADMAPIENTRY    ADM_ScOpen(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr, int verbose);
ADMAPIENTRY    ADM_ScClose(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr);
ADMAPIENTRY 	ADM_ReadScCfg(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int verbose);
ADMAPIENTRY 	ADM_ReadSCFile(ADMHANDLE adm_handle, int verbose);
ADMAPIENTRY    ADM_ScScan(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int verbose);


/*---------------------------------------------------------------------------
**	DEBUG PORT LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

ADMAPIENTRY 	ADM_ProcessDebug(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr);
ADMAPIENTRY 	ADM_DAWriteSendCtl(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int app_port, int marker);
ADMAPIENTRY 	ADM_DAWriteRecvCtl(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int app_port, int marker);
ADMAPIENTRY 	ADM_DAWriteSendData(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int app_port, int length, char * data_buff);
ADMAPIENTRY 	ADM_DAWriteRecvData(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr,
					int app_port, int length, char * data_buff);
ADMAPIENTRY		ADM_ConPrint(ADMHANDLE adm_handle, ADM_INTERFACE * adm_interface_ptr);
ADMAPIENTRY 	ADM_CheckDBPort(ADMHANDLE adm_handle);


/*---------------------------------------------------------------------------
**	FLASH LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

ADMAPIENTRYCP	ADM_FileGetString(ADMHANDLE adm_handle, char * SubSec, char * Topic);
ADMAPIENTRYU	ADM_FileGetInt(ADMHANDLE adm_handle, char * SubSec, char * Topic);
ADMAPIENTRYC	ADM_FileGetChar(ADMHANDLE adm_handle, char * SubSec, char * Topic);
ADMAPIENTRY		ADM_GetVal(ADMHANDLE adm_handle, char * buff);
ADMAPIENTRYC	ADM_GetChar(ADMHANDLE adm_handle, char * buff);
ADMAPIENTRY		ADM_GetStr(ADMHANDLE adm_handle, char * buff, char * fbuff);
ADMAPIENTRYCP	ADM_SkipToNext(ADMHANDLE adm_handle, char * buff);
ADMAPIENTRYC	ADM_Getc(ADMHANDLE adm_handle, char * buff);


/*---------------------------------------------------------------------------
**	RAM LIBRARY FUNCTION PROTOTYPES
**---------------------------------------------------------------------------
*/

ADMAPIENTRYL 	ADM_EEPROM_ReadConfiguration(ADMHANDLE adm_handle);
ADMAPIENTRYCHP	ADM_RAM_Find_Section(ADMHANDLE adm_handle, char * SubSec);

ADMAPIENTRYCHP	ADM_RAM_GetString(ADMHANDLE adm_handle, char huge * mydata, char * Topic);
ADMAPIENTRYU 	ADM_RAM_GetInt(ADMHANDLE adm_handle, char huge * mydata, char * Topic);
ADMAPIENTRYUL 	ADM_RAM_GetLong(ADMHANDLE adm_handle, char huge * mydata, char * Topic);
ADMAPIENTRYF 	ADM_RAM_GetFloat(ADMHANDLE adm_handle, char huge * mydata, char * Topic);
ADMAPIENTRYD 	ADM_RAM_GetDouble(ADMHANDLE adm_handle, char huge * mydata, char * Topic);
ADMAPIENTRYUC	ADM_RAM_GetChar(ADMHANDLE adm_handle, char huge * mydata, char * Topic);

ADMAPIENTRYV 	ADM_Get_BP_Data_Exchange(ADMHANDLE adm_handle);

ADMAPIENTRYUL 	ADM_PLX_ReadConfiguration(ADMHANDLE adm_handle, char huge** mydata);
ADMAPIENTRYCHP	ADM_PLX_FindSection(ADMHANDLE adm_handle, char * SubSec, char huge* mydata);

#endif
