/////////////////////////////////////////////////////////////////////////////
//
// CGI parser implemented to parse query string
//
// Copyright (c) 2011, ProSoft Technology, All Rights Reserved
//
// Author   : Henry Yu
//
// MODIFIED :
// 08/10/2011 HYU - Created
//
//
//
/////////////////////////////////////////////////////////////////////////////
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "cgiparse.h"



static CGI_parname *p_args;
static int p_num = 0;


char hexToChar(char first, char second)
{
    int digit;
    
    digit = (first >= 'A' ? ((first & 0xDF) - 'A') + 10 : (first - '0'));
    digit *= 16;
    digit += (second >= 'A' ? ((second & 0xDF) - 'A') + 10 : (second - '0'));
    return (char)(digit);
}

int form_urldecode(char *src, int len, char *dest, int size)
{
    char *result = dest;
    int i, n;
    char c;
    
    if (len == -1)
    {
        len = strlen(src);
    }
    
    for(i = 0, n = 0; i < len && n < size; i++)
    {
        switch(src[i])
        {
        case '+':
            *result = ' ';
            break;
        case '%':
            // Don't assume well-formed input
            if((len - i) >= 2
                && isxdigit(src[i + 1]) && isxdigit(src[i + 2]))
            {
                c = src[++i];
                *result = hexToChar(c, src[++i]);
            }
            // Just pass the % through untouched
            else
            {
                *result = '%';
            }
            
            break;
            
        default:
            *result = src[i];
            break;
        }
        result++;
        n++;
    }
    
    *result = '\0';
    
    return 0;
}

int CGIParse_Parse(void)
{
    int n;
    int reqMethod;

    char * reqMethodStr = getenv("REQUEST_METHOD");
    if ( reqMethodStr != NULL )
    {
        reqMethod = REQ_UNKNOWN;
        if ( strcmp ( reqMethodStr, "POST" ) == 0 ) reqMethod = REQ_POST;
        else if ( strcmp ( reqMethodStr, "GET" ) == 0 ) reqMethod = REQ_GET;
        else if ( strcmp ( reqMethodStr, "HEAD" ) == 0 ) reqMethod = REQ_HEAD;
        else if ( strcmp ( reqMethodStr, "PUT" ) == 0 ) reqMethod = REQ_PUT;
    }
    else
    {
        reqMethod = -1;
    }
    
    char * query_string = getenv ( "QUERY_STRING" );
    if (query_string == NULL)
    {
    	return 0;
    }

    char * pos;
    char * name;
    char * value;
    
    switch ( reqMethod )
    {
    case REQ_GET:
        p_num = 0;
        for ( pos = query_string; *pos != '\0'; pos++ )
        {
            if ( *pos == '=' ) p_num++;
        }
        
        p_args = malloc(sizeof( CGI_parname) * p_num );
        pos = query_string;
        for ( n = 0; n < p_num; n++ )
        {
            name = pos;
            pos = strchr(name, '=');
            if (pos == NULL)
            {
                break;
            }
            
            // Decode the name
            form_urldecode(name, pos - name, p_args[n].name, MAX_NAME_PARM_SIZE - 1);
            
            value = pos + 1;
            
            // Find the '&' separating subsequent name/value pairs
            pos = strchr(value, '&');
            
            // Even if an '&' wasn't found the rest of the string is a value
            form_urldecode(value, pos == NULL ? -1 : pos - value, p_args[n].parm, MAX_NAME_PARM_SIZE - 1);
            
            if (pos == NULL)
            {
                break;
            }
            pos++;
        }
        break;
    }
    
    return p_num;
}

void CGIParse_Release( void )
{
    if (p_args != NULL)
    {
        free(p_args);
        p_args = NULL;
    }
    p_num = 0;
}

const char* CGIParse_Name ( int i )
{
    return p_args[i].name;
}

const char* CGIParse_Parm ( int i )
{
    return p_args[i].parm;
}

int CGIParse_Num ( void )
{
    return p_num;
}

const char* CGIParse_GetParm ( const char *n )
{
    int i;
    
    for ( i = 0; i <= p_num; i++ )
    {
        if ( strcmp ( p_args[i].name, n ) == 0 )
            return p_args[i].parm;
    }
    return NULL;
}

