# Examples running of the script:

# 1. With minimal option:
# powershell ./build.ps1 -SHARED_FOLDER //192.168.1.73/WorkSpace

# All options:
# powershell ./build.ps1 -SHARED_FOLDER //192.168.1.73/WorkSpace -SHARED_FOLDER_USER user -SHARED_FOLDER_PASSWORD password -MVI_FOLDER mvi56e-ldm -IMAGECONTENTS_FILE_NAME imagecontents-tw

param (
#    [string]$SHARED_FOLDER="//$env:computername/WorkSpace"
	[string]$SHARED_FOLDER="//192.168.1.73/WorkSpace",
	[string]$SHARED_FOLDER_USER="user",
	[string]$SHARED_FOLDER_PASSWORD="password",
	[string]$MODULE="MVI69E",
	[string]$MVI_FOLDER="mvi69e-ldm",
	[string]$IMAGECONTENTS_FILE_NAME="imagecontents-tw"
 )

 if ($MODULE.Equals(""))
 {
    "Required argument MODULE is missing. Call the script like in the example below:"
    "./build.ps1 -MODULE MVI56E -SHARED_FOLDER //192.168.1.73/WorkSpace -SHARED_FOLDER_USER=user -SHARED_FOLDER_PASSWORD=password"
	exit
 }

# In case if container was left running at the previous step, stop it:
"If container psft-tw running, stop it ..."
docker container stop psft-tw

# Step 1: build Docker image using ..\docker\Dockerfile
"Building image psft-tw-build-machine ..."
#Note: to completely re-built image from scratch, add option --no-cache
docker build --tag=psft-tw-build-machine --build-arg SHARED_FOLDER=$SHARED_FOLDER --build-arg SHARED_FOLDER_USER=$SHARED_FOLDER_USER --build-arg SHARED_FOLDER_PASSWORD=$SHARED_FOLDER_PASSWORD ..\docker
if( -not $? )
{
	exit
}

# Step 2: Start container using the image built in step 1.
# Option --rm tells to delete container after stopping it
# Option -p 4422:22 maps SSH port from container to the port in host machine. 
# Option "name" defines name of the container.
docker run -d --name psft-tw --privileged --rm -p 4422:22 psft-tw-build-machine
if( -not $? )
{
	"Failed to start container"
	exit
}

# Step 3. Optionally, execute other commands in running container.
#docker container exec -it psft-tw /home/user/workspace/ThingWorx-ldm-interface-lib/scripts/build-tw-ldm.sh

# Next line calls script, which in turn builds firmware for project ThingWorx-LDM sample project. Build result will be available from the host machine.
if ( $MODULE.equals("MVI56E") )
{
	docker container exec psft-tw /home/user/workspace/ThingWorx-ldm-sample-app-mvi56e/build.sh -m $MVI_FOLDER -i $IMAGECONTENTS_FILE_NAME
}
elseif ($MODULE.equals("MVI69E") )
{
	docker container exec psft-tw /home/user/workspace/ThingWorx-ldm-sample-app-mvi69e/build.sh -m $MVI_FOLDER -i $IMAGECONTENTS_FILE_NAME
}

# Step 4. Uncomment next line to stop container after build is complete. 
# If it was started with option --rm, then after stopping the container will be removed.
if( $? )
{
#	docker container stop psft-tw
}
