/** $Revision:   1.1  $ **/

/************************************************************************
*
*   Title: MVI69E API library header file
*
*   Abstract:
*
*       Contains defininitions, structures, and function templates for
*       all functions defined in the MVI69E API.  This file is 
*       distributed as part of the API.
*
*   Environment:  MVI69E
*                 Linux
*
*                 Copyright (c) 2011 Online Development, Inc.
*
************************************************************************/

#ifndef MVI69API_H
#define MVI69API_H


/*=======================================================================
=                       DEFINITIONS
=======================================================================*/

/***************************************************
**  API Function Return Values
**
**  These values are returned by the API functions 
** to indicate success or possible error conditions.
****************************************************/

#define MVI69_SUCCESS           0       // function returned successfully
#define MVI69_ERR_BADPARAM      1       // parameter contains invalid value
#define MVI69_ERR_REOPEN        2       // already open
#define MVI69_ERR_NODEVICE      3       // device is not present
#define MVI69_ERR_NOACCESS      4       // handle is invalid or not opened
#define MVI69_ERR_TIMEOUT       5       // action timeout
#define MVI69_ERR_MSGTOOBIG     6       // The message is too large
#define MVI69_ERR_BADCONFIG     7       // The IO is not configured properly
#define MVI69_ERR_MEMALLOC      8       // Unable to allocate memory
#define MVI69_ERR_NOTSUPPORTED  9       // Function is not supported on this platform
#define MVI69_ERR_DRIVERFAIL    10      // Device driver error

/************************************
**    LED DEFINITIONS
**
**    These values are passed to the
**    MVI69_SetLED function.
*************************************/
/* LED Identifiers */
#define MVI69_LEDID_OK          1           // Selects OK LED
#define MVI69_LEDID_CFG         2           // Selects CFG LED
#define MVI69_LEDID_P1          3           // Selects P1 LED
#define MVI69_LEDID_P2          4           // Selects P2 LED
#define MVI69_LEDID_BP          5           // Selects BP LED
#define MVI69_LEDID_NET         6           // Selects NET LED

/* LED States */
#define MVI69_LED_STATE_OFF     0           // LED is OFF
#define MVI69_LED_STATE_GREEN   1           // LED is GREEN
#define MVI69_LED_STATE_RED     2           // LED is RED
#define MVI69_LED_STATE_YELLOW  3           // LED is YELLOW (RED & GREEN both on)

/***************************************************************
**    SERIAL PORT CONFIGURATION
**
**    These values are returned from the MVI69_GetSerialConfig 
**    function, and passed to the MVI69_SetSerialConfig function.
**
****************************************************************/
#define MVI69_SERIAL_CONFIG_NONE      0   // No jumper is installed
#define MVI69_SERIAL_CONFIG_RS232     1   // Port is configured for RS-232
#define MVI69_SERIAL_CONFIG_RS422     2   // Port is configured for RS-422
#define MVI69_SERIAL_CONFIG_RS485     4   // Port is configured for RS-485

/***************************************************************
**    SCAN MODE
**
**    These values are returned from the MVI69_GetScanMode
**    function.
**
****************************************************************/
#define MVI69_PROGRAM_MODE            0
#define MVI69_RUN_MODE                1

/***************************************************************
**    IO IMAGE MAXIMUM SIZES
**
**    These are the maximum supported sizes in words for the
**    input and output images.
**
****************************************************************/
#define MVI69_MAX_INPUT_WORDS       256
#define MVI69_MAX_OUTPUT_WORDS      256

/***************************************************************
**    MESSAGE BUFFER MAXIMUM SIZES
**
**    These are the maximum supported sizes in bytes for the
**    receive and send message buffers.
**
****************************************************************/
#define MVI69_MAX_MSG_RCVBUF_LEN    512
#define MVI69_MAX_MSG_SNDBUF_LEN    512


/* **********************************
**    TYPE DEFINITIONS
*************************************/
typedef unsigned long ULONG;
typedef unsigned long DWORD;
typedef unsigned char BYTE;
typedef unsigned char UCHAR;
typedef unsigned char * PUCHAR;
typedef unsigned short WORD;
typedef unsigned short USHORT;

typedef void VOID;
typedef void * PVOID;

typedef int MVI69HANDLE;    // access token


/*=======================================================================
=                       STRUCTURES
=======================================================================*/

/************************************************************
* Structure Name: MVI69VERSIONINFO
*
* Description:
*
*   Returned by MVI69_GetVersionInfo().
*   Software version numbers.
*
*************************************************************/
typedef struct tagMVI69VERSIONINFO
{
    int APISeries;         // API series
    int APIRevision;       // API revision
    int DDSeries;          // Device driver series
    int DDRevision;        // Device driver revision
} MVI69VERSIONINFO;

/************************************************************
* Structure Name: MVI69IOCONFIG
*
* Description:
*
*   Returned by MVI69_GetIOConfig().
*
*************************************************************/
typedef struct tagMVI69IOCONFIG
{
    WORD MappedInputWords;      // # of mapped input words
    WORD MappedOutputWords;     // # of mapped output words
    WORD MsgRcvBufSize;         // max size of received messages
    WORD MsgSndBufSize;         // mas size of sent messages
} MVI69IOCONFIG;


/************************************************************
* Structure Name: MVI69MODULEINFO
*
* Description:
*
*   Returned by MVI69_GetModuleInfo().
*
*************************************************************/
typedef struct tagMVI69MODULEINFO
{
    WORD    VendorID;           // Vendor identification
    WORD    DeviceType;         // Device type code
    WORD    ProductCode;        // Device model code
    BYTE    MajorRevision;      // Module major revision
    BYTE    MinorRevision;      // Module minor revision
    DWORD   SerialNo;           // Serial number
    BYTE    Name[32];           // Device name (string)
} MVI69MODULEINFO;


/************************************************************
* Structure Name: MVI69SPCONFIG
*
* Description:
*
*   Serial Port configuration structure
*
*************************************************************/
typedef struct _MVI69SPCONFIG {
    int port_num;
    int port_cfg;
} MVI69SPCONFIG, *PMVI69SPCONFIG;



/* Define a convenient macro for library function declarations */

#ifdef __cplusplus
#define MVI69APIENTRY extern "C" int
#else
#define MVI69APIENTRY int
#endif

/*=======================================================================
=                       FUNCTION PROTOTYPES
=======================================================================*/

MVI69APIENTRY MVI69_Open( MVI69HANDLE *handle );
MVI69APIENTRY MVI69_OpenNB( MVI69HANDLE *handle );
MVI69APIENTRY MVI69_Close( MVI69HANDLE handle );
MVI69APIENTRY MVI69_GetVersionInfo( MVI69HANDLE handle, MVI69VERSIONINFO *pVersion );
MVI69APIENTRY MVI69_SetLED( MVI69HANDLE handle, int which_led, int led_state );
MVI69APIENTRY MVI69_GetSetupJumper( MVI69HANDLE handle, int *mode );
MVI69APIENTRY MVI69_GetModuleInfo( MVI69HANDLE handle, MVI69MODULEINFO *pIdObj );
MVI69APIENTRY MVI69_SetModuleInfo( MVI69HANDLE handle, MVI69MODULEINFO *pIdObj );
MVI69APIENTRY MVI69_GetSerialConfig( MVI69HANDLE handle, MVI69SPCONFIG *spconfig );
MVI69APIENTRY MVI69_SetSerialConfig( MVI69HANDLE handle, MVI69SPCONFIG *spconfig );
MVI69APIENTRY MVI69_GetScanCounter( MVI69HANDLE handle, DWORD *count );
MVI69APIENTRY MVI69_GetScanMode( MVI69HANDLE handle, int *mode );
MVI69APIENTRY MVI69_GetIOConfig( MVI69HANDLE handle, MVI69IOCONFIG *iocfg );
MVI69APIENTRY MVI69_SetIOConfig( MVI69HANDLE handle, MVI69IOCONFIG *piocfg );
MVI69APIENTRY MVI69_ReadOutputImage( MVI69HANDLE handle, int offset, int len, WORD *data );
MVI69APIENTRY MVI69_WriteInputImage( MVI69HANDLE handle, int offset, int len, WORD *pdata );
MVI69APIENTRY MVI69_WaitForInputScan( MVI69HANDLE handle, int timeout );
MVI69APIENTRY MVI69_WaitForOutputScan( MVI69HANDLE handle, int timeout );
MVI69APIENTRY MVI69_GetMsgRequestFromBp( MVI69HANDLE handle, WORD *pBuffer, int *pLength , int timeout );
MVI69APIENTRY MVI69_SendMsgResponseToBp( MVI69HANDLE handle, WORD *pBuffer, int Length );

#endif  /* MVI69API_H */

