#include "mvi69-types-and-variables.h"
#include "unistd.h"
#include <stdio.h>
#include <string.h>
/* Definitions of global variables: */
MVI69HANDLE				MVI69_Handle = (MVI69HANDLE) 0;
MVI69MODULEINFO   Module_Info;
MVI69IOCONFIG 		IO_Config;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	open_backplane( void )
//			Input:
//					none
//
//			Output:
//					The global MVI69_Handle is set if successful.
//
//			Description:
//					Opens a connection to the backplane driver, allow access to some of the module hardware
// 				including backplane communication
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

int open_backplane(void)
{
	int					result;

	// set module information object

	Module_Info.VendorID = 309;  	// prosoft
	Module_Info.DeviceType = 12;  		// communications adapter
	Module_Info.ProductCode = 6112;		// EDS product code LDM
	Module_Info.MajorRevision = 1;		// major revision 1
	Module_Info.MinorRevision = 1;		// minor revision 1

	strcpy((char *)Module_Info.Name, "MVI69E-LDM");

	result = MVI69_SetModuleInfo(MVI69_Handle, &Module_Info);
	if (result != MVI69_SUCCESS)
	{
		tw_ldm_log(TW_LDM_LOG_ERROR, "mvi69 Set Module info failed: %d\n", result);
		return -1;
	}

	// open access to backplane/hardware driver

	result = MVI69_Open(&MVI69_Handle);

	while (result != MVI69_SUCCESS)
	{
		printf("Waiting for processor connection...: %d\n", result);
		usleep(1000);
	}
	
	result = MVI69_GetIOConfig(MVI69_Handle, &IO_Config);
	if (result != MVI69_SUCCESS)
	{
		tw_ldm_log(TW_LDM_LOG_ERROR, "MVI69 Get IO config failed: %d", result);
		return -1;
	}

	tw_ldm_log(TW_LDM_LOG_INFO, "IO Config: Input (Mapped words) %d", IO_Config.MappedInputWords);
	tw_ldm_log(TW_LDM_LOG_INFO, "IO Config: Output (Mapped words)  %d", IO_Config.MappedOutputWords);
	tw_ldm_log(TW_LDM_LOG_INFO, "IO Config: Received msg size(words) %d", IO_Config.MsgRcvBufSize);
	tw_ldm_log(TW_LDM_LOG_INFO, "IO Config: Sent Msg Size(words) %d", IO_Config.MsgSndBufSize);

	// make sure that the input and output sizes are not bigger than our buffer.

	if (IO_Config.MappedInputWords > MVI69_MAX_INPUT_WORDS)
		IO_Config.MappedInputWords = MVI69_MAX_INPUT_WORDS;

	if (IO_Config.MappedOutputWords > MVI69_MAX_OUTPUT_WORDS)
		IO_Config.MappedOutputWords = MVI69_MAX_OUTPUT_WORDS;


	// Read the Module information

	result = MVI69_GetModuleInfo(MVI69_Handle, &Module_Info);
	if (result != MVI69_SUCCESS)
	{
		tw_ldm_log(TW_LDM_LOG_ERROR, "MVI69 Get Module Info failed: %d\n", result);
		return -1;
	}
	else
	{
		tw_ldm_log(TW_LDM_LOG_INFO, "Module Information:");
		tw_ldm_log(TW_LDM_LOG_INFO, "::Vendor ID     : %d", Module_Info.VendorID);
		tw_ldm_log(TW_LDM_LOG_INFO, "::Device Type   : %d", Module_Info.DeviceType);
		tw_ldm_log(TW_LDM_LOG_INFO, "::Product Code  : %d", Module_Info.ProductCode);
		tw_ldm_log(TW_LDM_LOG_INFO, "::Major Rev.    : %d", Module_Info.MajorRevision);
		tw_ldm_log(TW_LDM_LOG_INFO, "::Minor Rev.    : %d", Module_Info.MinorRevision);
		tw_ldm_log(TW_LDM_LOG_INFO, "::Serial No.    : %lu (0x%04lX)", Module_Info.SerialNo, Module_Info.SerialNo);
		tw_ldm_log(TW_LDM_LOG_INFO, "::Name          : %s", Module_Info.Name);
	}
	PLC_DB_Initialized = TRUE;
	return 0;
}

int tw_ldm_get_status(char is_verbose, char** buffer, uint16_t max_size)
{
	const char* log_file_name = "/www/html/log/messages.txt";

	if (!is_verbose)
	{
		static char status_to_return[128];
		memset(status_to_return, 0, sizeof(status_to_return));

		if (PLC_DB_Initialized)
		{
			sprintf(status_to_return, "%s, %s", "OK", MODE(run_mode));
		}
		else
		{
			sprintf(status_to_return, "%s", "Not connected");
		}

		uint16_t len = (uint16_t)strlen(status_to_return);
		if (!*buffer)
		{
			*buffer = (char*)malloc(len + 1);
			if (*buffer)
				return -1;
		}
		if (len > max_size)
			len = max_size;
		(*buffer)[len] = 0;
		if (len > 0)
			strncpy(*buffer, status_to_return, len);
		return 0;
	}

	// If verbose, then return content of the log file.
	else
	{
		FILE* f = fopen(log_file_name, "r");
		long file_size;
		size_t read_bytes;

		uint16_t bytes_to_read;
		if (!f)
			return -1;
		fseek(f, 0, SEEK_END);
		file_size = ftell(f);

		if (max_size > 0 && file_size > max_size)
			bytes_to_read = max_size;
		else
		{
			if (file_size > 0x7FFE)
				bytes_to_read = 0x7FFE;
			else
				bytes_to_read = (uint16_t)file_size;
		}

		if (!*buffer)
		{
			*buffer = (char*)malloc(bytes_to_read + 1);
			if (!*buffer)
				return -1;
		}
		fseek(f, file_size - bytes_to_read, SEEK_SET);
		read_bytes = fread(*buffer, 1, bytes_to_read, f);
		fclose(f);

		(*buffer)[bytes_to_read] = 0;
		if (read_bytes == bytes_to_read)
			return 0;
		else
			return -1;
	}
}