/*
|============================================================================
|
|       Copyright (C) 2012 ProSoft Technology. All rights reserved.
|
|  File:             sputil.c
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build    08/22/2012 HYU              Created.
|============================================================================
*/
#include <stdio.h>
#include <sys/mman.h>
#include <unistd.h>
#include <fcntl.h>
#include "gpio.h"
#include "sputil.h"


#define PORT_1_2_SWAPPED

// Definitions of registers used in the PLX30 hardware UARTS
#ifdef PORT_1_2_SWAPPED
#define USART1_ADDRESS 0xFFFB4000
#define USART2_ADDRESS 0xFFFB0000
#else
#define USART1_ADDRESS 0xFFFB0000
#define USART2_ADDRESS 0xFFFB4000
#endif
#define USART3_ADDRESS 0xFFFB8000
#define USART4_ADDRESS 0xFFFD0000



int spOpenPortMemMap(int comport, int *memfd, void **memPage)
{
    unsigned long uartAddr;
    
    //Memory map the respective address
    switch (comport)
    {
    case COM1:
        uartAddr = USART1_ADDRESS;
        break;
    case COM2:
        uartAddr = USART2_ADDRESS;;
        break;
    case COM3:
        uartAddr = USART3_ADDRESS;;
        break;
    case COM4:
        uartAddr = USART4_ADDRESS;;
        break;
    default:
        return -1;
    }
    
    // Open the memory device so we can read and write memory
    int fd = open("/dev/mem", O_RDWR);

    *memPage = mmap(0, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED, fd, uartAddr);

	*memfd = fd;

	return 0;
}

int spClosePortMemMap(int memfd, void *memPage)
{
    //Unmap the respective memory address
    munmap(memPage, getpagesize());
    
    // Close the memory device
    close(memfd);

    return 0;
}

int spSetPortMode(int comport, int mode)
{
    struct at91_gpio gpio[2];
    
    switch (comport)
    {
#ifdef PORT_1_2_SWAPPED
    case COM1:
        gpio[0].pin = AT91_PIN_PB21;
        gpio[1].pin = AT91_PIN_PB13;
        break;

    case COM2:
        gpio[0].pin = AT91_PIN_PA26;
        gpio[1].pin = AT91_PIN_PA27;
        break;
#else
    case COM1:
        gpio[0].pin = AT91_PIN_PA26;
        gpio[1].pin = AT91_PIN_PA27;
        break;

    case COM2:
        gpio[0].pin = AT91_PIN_PB21;
        gpio[1].pin = AT91_PIN_PB13;
        break;
#endif
        
    case COM3:
        gpio[0].pin = AT91_PIN_PC0;
        gpio[1].pin = AT91_PIN_PC2;
        break;
        
    case COM4:
        gpio[0].pin = AT91_PIN_PB12;
        gpio[1].pin = AT91_PIN_PC3;
        break;
        
    default:
        return -1;
        
    }
    
    switch (mode)
    {
    case MODE_RS232:
        gpio[0].value = 0;
        gpio[1].value = 1;
        break;
        
    case MODE_RS485R:
        gpio[0].value = 0;
        gpio[1].value = 0;
        break;
        
    case MODE_RS485T:
    case MODE_RS422:
        gpio[0].value = 1;
        gpio[1].value = 0;
        break;
        
    default:
        gpio[0].value = 0;
        gpio[1].value = 1;
        break;
    }
    
    int fd = open(GPIO_DEVICE_NAME, O_RDWR);
    if (fd < 0)
    {
        return -1;
    }
    
    write(fd, &gpio[0], sizeof(struct at91_gpio));
    write(fd, &gpio[1], sizeof(struct at91_gpio));
    
    close(fd);
    
    return 0;
}

