///////////////////////////////////////////////////////////////////////////////
//
// FILEPARS.C
//
// (c) 1998-2004, Vital Computer Solutions, All Rights Reserved
// Richard A. Reynolds
//
// This file contains Trade Secret Information of R-Squared Software, Inc.
// All rights reserved by R-Squared Software, Inc.
//  (c) 2004-2008, R-Squared Software, Inc., All rights reserved, 
//  Richard A. Reynolds, R-Squared Software, Inc.
//
// This file contains the standard file parsing functions.
//
// DATE     : 03/03/2000
// MODIFIED :
//  02/12/2003 -- Fixed problem if ':' or '=' is not found after item name.
//                Removed unused functions.
//  10/25/2011 HYU - Added Record_gethex().
//  12/06/2011 HYU - Added File_GetInt16_Seek and File_GetInt32_Seek.
//
//
//
///////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "plxdef.h"
#include "filepars.h"


int Record_getval(char * buff)
{
	return atoi(buff);
}

int Record_gethex(char * buff)
{
    int rval = 0;
    sscanf(buff, "%x", &rval);
    return rval;
}

unsigned long Record_getlong(char * buff)
{
	return atol(buff);
}


char   Record_getchar(char * buff)
{
	while(isspace(*buff) && *buff)		//skip white space
		buff++;

   *buff = (*buff >= 'a' && *buff <='z') ? *buff & 0x5f : *buff; //return upper-case character value
	return *buff;
}


void   Record_getstr(char * buff, char * fbuff, int buffSize)
{
	int i = 0;

	while(isspace(*buff) && *buff)		//skip white space
		buff++;

	buffSize--;
	while(*buff && !isspace(*buff) && i < buffSize)     //copy string
	{
		*fbuff++ = *buff++;
		i++;
	}

	*fbuff = 0; //null terminate the string
}


void   Record_getIP(char * buff, char * fbuff)
{
	int i = 0;
   char * cptr = fbuff;

	while((isspace(*buff)) && *buff)		//skip white space
		buff++;

//	while(*buff && *buff != ' ' && i < 15)     //copy string
//	while(*buff && *buff != ' ' && *buff != '\t' && *buff != '\r' && *buff != '\n' && i < 15)
	while(*buff && !(isspace(*buff)) && *buff != '\r' && *buff != '\n' && i < 15)
	{
		*cptr++ = *buff++;      //copy string
		i++;                    //and count characters
	}

	*cptr = 0;                 //null terminate the string

   i = strlen(fbuff);
   while(i)
   {
         if(fbuff[i-1] == ' ' || fbuff[i-1] == '\n' || fbuff[i-1] == '\r')
         {
            fbuff[i-1] = 0;
         }
         i--;
   }
}

char * skiptonext(char * buff)
{
	while(!isspace(*buff) && *buff) //skip data until white space
		buff++;
	while(isspace(*buff) && *buff)  //skip white space
		buff++;
	if(*buff == 0)  //return if no data found
		return NULL;
	else
		return buff;
}


int File_Find_Section(FILE * fptr, char * SubSec)
{
	char buff[200];

	fseek(fptr, 0, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr))
	{
		if(!strnicmp(buff, SubSec, strlen(SubSec)))	//found subsection
		{
			return 1;
		}
	}
	return 0;
}

char * File_GetString_Seek(FILE * fptr, long FLoc, char * Topic, char * buff)
{
	char * cptr, * eptr;

	fseek(fptr, FLoc, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr))
	{
		if(*buff == '[')   //new subsection entered
			return (char *) NULL;

		if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
		{
			cptr = strchr(buff, ':');  //find first ':' delimiter
         if(!cptr)
				return (char *) NULL;  //if not return
			cptr++;                    //skip over ':'
			while(isspace(*cptr))	   //skip white space at before
				cptr++;
			eptr = buff + strlen(buff) - 1; //end of buffer
			while(*eptr <= 32)         //remove white space & control
				eptr--;                //characters from end of string
			eptr++;                    //move forward to place 0
			if(eptr < cptr)            //check to make sure string is valid
				return (char *) NULL;  //if not return
			*eptr = 0;                 //else null terminate string
			return cptr;               //returned the string found
		}
	}
	return (char *) NULL;
}


unsigned short File_GetInt_Seek(FILE * fptr, long FLoc, char * Topic)
{
    return (unsigned short)File_GetInt32_Seek(fptr, FLoc, Topic);
}


short File_GetInt16_Seek(FILE * fptr, long FLoc, char * Topic)
{
    return (short)File_GetInt32_Seek(fptr, FLoc, Topic);
}


int File_GetInt32_Seek(FILE * fptr, long FLoc, char * Topic)
{
	char * cptr;
	char buff[200];

	fseek(fptr, FLoc, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr))
	{
		if(*buff == '[')   //new subsection entered
			return 0;

		if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
		{
			cptr = strchr(buff, ':');	//find : character
         if(!cptr)
				return 0;  //if not return
			cptr++;						//skip over : for integer value
			return atoi(cptr);			//return value
		}
	}
	return 0;
}


int File_GetPtr_Seek(FILE * fptr, long FLoc, char * Topic)
{
    char * cptr;
    char buff[200];
    
    fseek(fptr, FLoc, SEEK_SET);	//start at beginning of file
    
    while(fgets( buff, 199, fptr))
    {
        if(*buff == '[')   //new subsection entered
            return -1;
        
        if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
        {
            cptr = strchr(buff, ':');	//find : character
            if(!cptr)
                return -1;  //if not return
            cptr++;						//skip over : for integer value
            return atoi(cptr);			//return value
        }
    }
    return -1;
}


unsigned long File_GetLong_Seek(FILE * fptr, long FLoc, char * Topic)
{
	char * cptr;
	char buff[200];

	fseek(fptr, FLoc, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr))
	{
		if(*buff == '[')   //new subsection entered
        {
			return 0;
        }

		if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
		{
			cptr = strchr(buff, ':');	//find : character
         if(!cptr)
				return 0;  //if not return
			cptr++;						//skip over : for integer value
			return (unsigned long) atol(cptr);			//return value
		}
	}
	return 0;
}


unsigned char File_GetChar_Seek(FILE * fptr, long FLoc, char * Topic)
{
	char * cptr;
	char buff[200];

	fseek(fptr, FLoc, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr))
	{
		if(*buff == '[')   //new subsection entered
			return ' ';

		if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
		{
			cptr = strchr(buff, ':');	//find : character
         if(!cptr)
				return ' ';  //if not return
			cptr++;						//skip over : for character value
			while(isspace(*cptr))	//skip white space
				cptr++;
         return (*cptr >= 'a' && *cptr <='z') ? *cptr & 0x5f : *cptr; //return upper-case character value
		}
	}
	return ' ';
}

float File_GetFloat_Seek(FILE * fptr, long FLoc, char * Topic)
{
	char * cptr;
	char buff[200];

	fseek(fptr, FLoc, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr))
	{
		if(*buff == '[')   //new subsection entered
        {
			return 0.00;
        }

		if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
		{
			cptr = strchr(buff, ':');	//find : character
         if(!cptr)
            return 0.00;
			cptr++;						//skip over : for integer value
			return (float) atof(cptr);			//return value
		}
	}
	return 0.00;
}

double File_GetDouble_Seek(FILE * fptr, long FLoc, char * Topic)
{
	char * cptr;
	char buff[200];

	fseek(fptr, FLoc, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr))
	{
		if(*buff == '[')   //new subsection entered
        {
			return 0.00;
        }

		if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
		{
			cptr = strchr(buff, ':');	//find : character
         if(!cptr)
            return 0.00;
			cptr++;						//skip over : for integer value
			return (double) atof(cptr);			//return value
		}
	}
	return 0.00;
}

//Not used in MVI module so removed -- 02/12/2003 by RAR
#if 0
//new function to read data from the
char * WFile_GetString(FILE * fptr, char * Topic, char * buff)
{
	char * cptr, * eptr;
	int found = FALSE;

	fseek(fptr, 0, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr) && !found)
	{
		while(fgets(buff, 199, fptr) && !found)
		{
			if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
			{
				cptr = strchr(buff, '=');  //find first '=' delimiter
            if(!cptr)
					return (char *) NULL;  //if not return
				cptr++;                    //skip over '='
				while(isspace(*cptr))	   //skip white space at before
					cptr++;
				eptr = buff + strlen(buff) - 1; //end of buffer
				while(*eptr <= 32)         //remove white space & control
					eptr--;                //characters from end of string
				eptr++;                    //move forward to place 0
				if(eptr < cptr)            //check to make sure string is valid
					return (char *) NULL;  //if not return
				*eptr = 0;                 //else null terminate string
				return cptr;               //returned the string found
			}
		}
	}
	return (char *) NULL;
}


char * File_GetString(FILE * fptr, char * SubSec, char * Topic, char * buff)
{
	char * cptr, * eptr;
	int found = FALSE;

	fseek(fptr, 0, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr) && !found)
	{
		if(!strnicmp(buff, SubSec, strlen(SubSec)))	//found subsection
		{
			while(fgets(buff, 199, fptr) && !found)
			{
				if(*buff == '[')   //new subsection entered
					return (char *) NULL;

				if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
				{
					cptr = strchr(buff, ':');  //find first ':' delimiter
               if(!cptr)
	   				return (char *) NULL;  //if not return
					cptr++;                    //skip over ':'
					while(isspace(*cptr))	   //skip white space at before
						cptr++;
					eptr = buff + strlen(buff) - 1; //end of buffer
					while(*eptr <= 32)         //remove white space & control
						eptr--;                //characters from end of string
					eptr++;                    //move forward to place 0
					if(eptr < cptr)            //check to make sure string is valid
						return (char *) NULL;  //if not return
					*eptr = 0;                 //else null terminate string
					return cptr;               //returned the string found
				}
			}
		}
	}
	return (char *) NULL;
}


unsigned short File_GetInt(FILE * fptr, char * SubSec, char * Topic)
{
	char * cptr;
	char buff[200];
	int found = FALSE;

	fseek(fptr, 0, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr) && !found)
	{
		if(!strnicmp(buff, SubSec, strlen(SubSec)))	//found subsection
		{
			while(fgets(buff, 199, fptr) && !found)
			{
				if(*buff == '[')   //new subsection entered
					return 0;

				if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
				{
					cptr = strchr(buff, ':');	//find : character
               if(!cptr)
   					return 0;  //if not return
					cptr++;						//skip over : for integer value
					return (unsigned short) atoi(cptr);			//return value
				}
			}
		}
	}
	return 0;
}


unsigned short File_GetPtr(FILE * fptr, char * SubSec, char * Topic)
{
	char * cptr;
	char buff[200];
	int found = FALSE;

	fseek(fptr, 0, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr) && !found)
	{
		if(!strnicmp(buff, SubSec, strlen(SubSec)))	//found subsection
		{
			while(fgets(buff, 199, fptr) && !found)
			{
				if(*buff == '[')   //new subsection entered
					return -1;

				if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
				{
					cptr = strchr(buff, ':');	//find : character
               if(!cptr)
   					return -1;  //if not return
					cptr++;						//skip over : for integer value
					return (unsigned short) atoi(cptr);			//return value
				}
			}
		}
	}
	return -1;
}


unsigned char File_GetChar(FILE * fptr, char * SubSec, char * Topic)
{
	char * cptr;
	char buff[200];
	int found = FALSE;

	fseek(fptr, 0, SEEK_SET);	//start at beginning of file

	while(fgets( buff, 199, fptr) && !found)
	{
		if(!strnicmp(buff, SubSec, strlen(SubSec)))	//found subsection
		{
			while(fgets(buff, 199, fptr) && !found)
			{
				if(*buff == '[')   //new subsection entered
					return ' ';

				if(!strnicmp(buff, Topic, strlen(Topic)))	//found topic
				{
					cptr = strchr(buff, ':');	//find : character
               if(!cptr)
   					return ' ';  //if not return
					cptr++;						//skip over : for character value
					while(isspace(*cptr))	//skip white space
						cptr++;
               return (*cptr >= 'a' && *cptr <='z') ? *cptr & 0x5f : *cptr; //return upper-case character value
				}
			}
		}
	}
	return ' ';
}
#endif

