#ifndef tw_ldm_interface_lib_h_
#define tw_ldm_interface_lib_h_
#include "load_and_parse_configuration_file.h"

#ifdef __cplusplus
extern "C"
{
#endif
	extern	tw_ldm_config gl_app_config;

	typedef void(*get_app_key_callback_function_type)(char* appKeyBuffer, unsigned int maxLength);

	extern int tw_ldm_initialize(const char* path_to_config_file, get_app_key_callback_function_type app_key_cb_function);

	extern int tw_ldm_connect(void);

	extern int tw_ldm_disconnect(void);
	
	extern int tw_ldm_is_connected(void);
	extern int tw_ldm_is_connecting(void);
	
	extern int tw_ldm_clean(void);

	extern uint32_t get_tick_count(void);

#ifndef TW_LDM_DEVICE_NOT_CONNECTED
#define TW_LDM_DEVICE_NOT_CONNECTED 0xFFF
#endif
  // Functions which must be implemented by an application using this library, to provide real time data for named tags.
	/* Function tw_ldm_read_value
	*  returns: 0 in case of success, TW_LDM_DEVICE_NOT_CONNECTED if underlaying device (PLC) is not connected, other value in case of read error.
	*/
	extern int tw_ldm_read_value(tw_tag* tag, plc_value* value);

	extern int tw_ldm_write_value(tw_tag* tag, plc_value* value);
	
	/* Function tw_ldm_get_status
	*	Returns brief current status information into provided buffer.
	* If buffer is NULL, then allocates memory for it, which must be freed by the caller using TW_FREE.
	* Returns 0 in case of success.
	*/
	extern int tw_ldm_get_status(char is_verbose, char** buffer, uint16_t max_size);

	/* If the gateway is connected to the PLC, then returns 1. Otherwise, returns 0 */
	extern int tw_ldm_is_connected_to_plc(void);

	enum tw_ldm_log_level
	{
		TW_LDM_LOG_ERROR = 3,
		TW_LDM_LOG_WARNING = 4,
		TW_LDM_LOG_NOTICE = 5,
		TW_LDM_LOG_INFO = 6,
		TW_LDM_LOG_DEBUG = 7
	};

	extern void tw_ldm_log(enum tw_ldm_log_level log_level, const char *format, ...);

#ifdef __cplusplus
}

#endif
#endif
