/*
|============================================================================
|
|       Copyright (C) 2011-2012 ProSoft Technology. All rights reserved.
|
|  File:             PLXUtil.h
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     8/23/2011 HYU              Created.
|           09/19/2011 HYU      Added getElapsedTime().
|           01/11/2012 HYU      Added ResetModule() and RestartModule().
|           10/02/2012 HYU      Added getElapsedTimeFrom().
|           11/16/2012 HYU      Added safe_snprintf().
|============================================================================
*/
#ifndef _PLXUTIL_H
#define _PLXUTIL_H

int GetModuleVersionInfo(char * verInfo, int len);
void ResetModule(void);
void RestartModule(void);

long small2_clock(void);
unsigned long timediff(unsigned long oldTime, unsigned long newTime);
long getElapsedTime(void);
long getElapsedTimeFrom( long long *lasttime );

char* stolower( char* str );
int TrimRight(char *s);
int safe_snprintf(char *str, unsigned int size, const char *format, ...);

#endif
