# Program to create image files for the ProLinx projects
import tarfile
import re
import shlex
import gzip
import os
import sys
from time import strftime


#firmware data file destination, Setup in the imagecontents file
firmwareDataFilename = None
# Release Notes
releaseNotesFilename = "firmware/ReleaseNotes.txt"

#Image contents file
imageContentsFilename = "imagecontents"

if (len(sys.argv) > 1):
  imageContentsFilename = sys.argv[1]

#Temporary Image contents file
tempImageContentsFilename = "imagecontents.tmp"

# Filename of the output file
outputFileName = None
# Filename of the output .tar file
outputTarFile = None
# Product Type for this image
productType = None
# Product Name for this image
productName = None
# Product Code for this image
productCode = None
# Revision for this image
revision    = None
# Build Number, initially setup by the user and then autoincremented
buildNumber = None

# Line that is currently being processed
line = None

defaultOwnerName = "root"
defaultPermissions = 0o644

# Function that parses permissions in unix format (rwxrwSrwt) and 
# converts it to the octal representation number
def parsePermissions(permissionsString):
    permissionsNumber = 0
    
    if (len(permissionsString)!=9):
        print  "Invalid permissions string in line:\n" + line
        exit()
    if ((permissionsString[0]!="r") & (permissionsString[0]!="-")):
        print  "Invalid permissions string in line:\n" + line
        exit()
        
        
    if (permissionsString[0]=="r"):
        permissionsNumber += 0o0400
    if (permissionsString[1]=="w"):
        permissionsNumber += 0o0200
    if (permissionsString[2]=="x"):
        permissionsNumber += 0o0100
    if (permissionsString[2]=="s"):
        permissionsNumber += 0o4100
    if (permissionsString[2]=="S"):
        permissionsNumber += 0o4000
    if (permissionsString[3]=="r"):
        permissionsNumber += 0o0040
    if (permissionsString[4]=="w"):
        permissionsNumber += 0o0020
    if (permissionsString[5]=="x"):
        permissionsNumber += 0o0010
    if (permissionsString[5]=="s"):
        permissionsNumber += 0o2010
    if (permissionsString[5]=="S"):
        permissionsNumber += 0o2000
    if (permissionsString[6]=="r"):
        permissionsNumber += 0o004
    if (permissionsString[7]=="w"):
        permissionsNumber += 0o002
    if (permissionsString[8]=="x"):
        permissionsNumber += 0o001
    if (permissionsString[8]=="t"):
        permissionsNumber += 0o1001
    if (permissionsString[8]=="T"):
        permissionsNumber += 0o1000
    
    return permissionsNumber

# Function to add a file to the Tar file. Uses the parameters from
# the configuration file in this order
# add [current filesystem name] [unix filesystem name] [Unix permissions]
def addFile(currentLine):
    if (len(currentLine)<3):
        print  "Missing parameters for \"add\" command in line:\n" + line
        exit()
    if (len(currentLine)>4):
        print  "Unknown parameters for \"add\" command in line:\n" + line
        exit()
    if (len(currentLine)==3):
        localFilename = currentLine[1]
        tarFilename   = currentLine[2]
        permissions   = defaultPermissions
    if (len(currentLine)==4):
        localFilename = currentLine[1]
        tarFilename   = currentLine[2]
        permissions   = parsePermissions(currentLine[3])
    # Try to add the file to the TAR file but check for exceptions
    try:
        info = outputTarFile.gettarinfo(name=localFilename,arcname=tarFilename)
        info.mode = permissions
        info.uname = "root"
        info.uid = 0
        info.gname = "root"
        info.gid = 0
        outputTarFile.addfile(info,fileobj=open(localFilename,"rb"));
    except:
        print  "Missing file for \"add\" command in line:\n" + line
        exit()
        


#MAIN: This is the equivalent to MAIN


# Read the whole config file
configfile = open(imageContentsFilename,"r")
# a new config file will be created with the changes
newconfigfile = open(tempImageContentsFilename,"w");
for line in configfile:
    # shlex allows to split lines with embedded quotes like 
    #"file 1" file2 would give me ['file 1','file2']
    # and to jump comment lines with #  
    currentLine = shlex.split(line,True);
    # Only check non empty lines
    if (len(currentLine)>0): 
        if (currentLine[0]=="add"):
            addFile(currentLine)
        if (currentLine[0]=="outputfile"):
            if (len(currentLine)<2):
                print "Missing parameters for \"outputfile\" command in line:\n" + line
                exit()
            outputTarFile = tarfile.open(currentLine[1]+".tar", "w") 
            outputFileName = currentLine[1] 
        if (currentLine[0]=="firmwaredatafile"):
            if (len(currentLine)<2):
                print "Missing parameters for \"firmwaredatafile\" command in line:\n" + line
                exit()
            firmwareDataFilename = currentLine[1] 
        if (currentLine[0]=="producttype"):
            if (len(currentLine)<2):
                print "Missing parameters for \"producttype\" command in line:\n" + line
                exit()
            productType = currentLine[1] 
        if (currentLine[0]=="productname"):
            if (len(currentLine)<2):
                print "Missing parameters for \"productname\" command in line:\n" + line
                exit()
            productName = currentLine[1]
        if (currentLine[0]=="productcode"):
            if (len(currentLine)<2):
                print "Missing parameters for \"productcode\" command in line:\n" + line
                exit()
            productCode = currentLine[1] 
        if (currentLine[0]=="revision"):
            if (len(currentLine)<2):
                print "Missing parameters for \"revision\" command in line:\n" + line
                exit()
            revision = currentLine[1] 
        if (currentLine[0]=="build"):
            if (len(currentLine)<2):
                print "Missing parameters for \"build\" command in line:\n" + line
                exit()
            readBuildNumber = int(currentLine[1]) 
            if ((readBuildNumber>999) or (readBuildNumber<0)):
                print "Invalid build number. \nBump version and set build number to 0. In line:\n" + line
                exit()
            buildNumber = "%03d" % (readBuildNumber + 1);
            versionCode = revision + "." + buildNumber

            # increment the build number 
            line = "build \t%03d\n" % (readBuildNumber + 1);
            # create the firmware data file that contains firmware file version information
            firmwareDataFile = open(firmwareDataFilename,"w");
            
            # This file is in the form of VariableName and VariableValue,
            # separated by Colon. 
            firmwareDataFile.write("PRODUCT_TYPE:" + productType + "\n")
            firmwareDataFile.write("PRODUCT_NAME:" + productName + "\n")
            firmwareDataFile.write("PRODUCT_CODE:" + productCode + "\n")
            firmwareDataFile.write("FIRMWARE_DATE:" + strftime("%m/%d/%Y")+"\n")
            firmwareDataFile.write("BUILD_NUMBER:" + buildNumber + "\n")
            firmwareDataFile.write("FIRMWARE_VERSION:" + versionCode + "\n")
            firmwareDataFile.close()
            
            
    # a new file is written with possible changes
    newconfigfile.write(line);
    

# By this time the TAR file should be generated and everything seems 
# to be right    

configfile.close();
newconfigfile.close();


if (outputTarFile!=None):
    outputTarFile.close()
    # gzip the Tar file
    f_in = open(outputFileName + ".tar", 'rb')
    f_out = gzip.open(outputFileName + ".tgz", 'wb')
    f_out.writelines(f_in)
    f_out.close()
    f_in.close()
    firmwareFile = outputFileName + "_" + revision + "." + buildNumber + "_" + strftime("%Y-%m-%d") + ".firmware"
    #    os.remove(outputFileName)
    
    #update the imagecontents file
    os.remove(imageContentsFilename)
    os.rename(tempImageContentsFilename,imageContentsFilename)
     
    # The ReleaseNotes file is opened and modified with this version data
    releaseNotesFile = open(releaseNotesFilename,"a");
    releaseNotesFile.write("\nVersion: " + versionCode)
    releaseNotesFile.write("\nDate: " + strftime("%m/%d/%Y"))
    releaseNotesFile.write("\nDescription: ")

    # Write down changes for this revision
    if (len(sys.argv) > 1):
        changes = sys.argv[1]
    else:
        changes = "New build."
    if ((changes==None) or (changes=="")):
        releaseNotesFile.close()
        os.system("notepad.exe " + releaseNotesFilename) 
    else:
        releaseNotesFile.write(changes + "\r\n")
        releaseNotesFile.close()
        
	os.system("mv " + outputFileName + ".tgz " + firmwareFile)
    os.system("chmod +r " + firmwareFile )
    os.remove(outputFileName + ".tar")
    #os.remove(outputFileName + ".tgz")

print("Done!")

# End "createimage.py"
